/*
 Highcharts JS v11.0.1 (2023-05-08)

 3D features for Highcharts JS

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/highcharts-3d",["highcharts"],function(C){a(C);a.Highcharts=C;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function C(a,w,m,M){a.hasOwnProperty(w)||(a[w]=M.apply(null,m),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:w,module:a[w]}})))}a=a?a._modules:
    {};C(a,"Core/Math3D.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,w){function m(a,h,g,c){var l=h.options.chart.options3d;const k=A(c,g?h.inverted:!1),B={x:h.plotWidth/2,y:h.plotHeight/2,z:l.depth/2,vd:A(l.depth,1)*A(l.viewDistance,0)},v=h.scale3d||1;c=J*l.beta*(k?-1:1);l=J*l.alpha*(k?-1:1);var F=Math.cos(l),n=Math.cos(-c),q=Math.sin(l),D=Math.sin(-c);g||(B.x+=h.plotLeft,B.y+=h.plotTop);return a.map(function(c){var g=(k?c.y:c.x)-B.x;var a=(k?c.x:c.y)-B.y;c=(c.z||0)-B.z;g={x:n*g-D*c,
    y:-q*D*g+F*a-n*q*c,z:F*D*g+q*a+F*n*c};a=r(g,B,B.vd);a.x=a.x*v+B.x;a.y=a.y*v+B.y;a.z=g.z*v+B.z;return{x:k?a.y:a.x,y:k?a.x:a.y,z:a.z}})}function r(a,h,g){h=0<g&&g<Number.POSITIVE_INFINITY?g/(a.z+h.z+g):1;return{x:a.x*h,y:a.y*h}}function k(a){let h=0,g,c;for(g=0;g<a.length;g++)c=(g+1)%a.length,h+=a[g].x*a[c].y-a[c].x*a[g].y;return h/2}const {deg2rad:J}=a,{pick:A}=w;return{perspective:m,perspective3D:r,pointCameraDistance:function(a,h){var g=h.options.chart.options3d,c=h.plotWidth/2;h=h.plotHeight/2;
        g=A(g.depth,1)*A(g.viewDistance,0)+g.depth;return Math.sqrt(Math.pow(c-A(a.plotX,a.x),2)+Math.pow(h-A(a.plotY,a.y),2)+Math.pow(g-A(a.plotZ,a.z),2))},shapeArea:k,shapeArea3D:function(a,h,g){return k(m(a,h,g))}}});C(a,"Core/Renderer/SVG/SVGElement3D.js",[a["Core/Color/Color.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,w,m){const {parse:r}=a,{defined:k,merge:J,objectEach:A,pick:G}=m,h={base:{initArgs:function(a){const c=this,g=c.renderer,h=g[c.pathType+"Path"](a),k=h.zIndexes;
            c.parts.forEach(function(a){const l={"class":"highcharts-3d-"+a,zIndex:k[a]||0};g.styledMode&&("top"===a?l.filter="url(#highcharts-brighter)":"side"===a&&(l.filter="url(#highcharts-darker)"));c[a]=g.path(h[a]).attr(l).add(c)});c.attr({"stroke-linejoin":"round",zIndex:k.group});c.originalDestroy=c.destroy;c.destroy=c.destroyParts;c.forcedSides=h.forcedSides},singleSetterForParts:function(a,c,l,h,k,v){const g={};h=[null,null,h||"attr",k,v];const n=l&&l.zIndexes;l?(n&&n.group&&this.attr({zIndex:n.group}),
            A(l,function(c,h){g[h]={};g[h][a]=c;n&&(g[h].zIndex=l.zIndexes[h]||0)}),h[1]=g):(g[a]=c,h[0]=g);return this.processParts.apply(this,h)},processParts:function(a,c,h,k,r){const g=this;g.parts.forEach(function(l){c&&(a=G(c[l],!1));if(!1!==a)g[l][h](a,k,r)});return g},destroyParts:function(){this.processParts(null,null,"destroy");return this.originalDestroy()}}};h.cuboid=J(h.base,{parts:["front","top","side"],pathType:"cuboid",attr:function(a,c,h,r){if("string"===typeof a&&"undefined"!==typeof c){const g=
        a;a={};a[g]=c}return a.shapeArgs||k(a.x)?this.singleSetterForParts("d",null,this.renderer[this.pathType+"Path"](a.shapeArgs||a)):w.prototype.attr.call(this,a,void 0,h,r)},animate:function(a,c,l){if(k(a.x)&&k(a.y)){a=this.renderer[this.pathType+"Path"](a);const g=a.forcedSides;this.singleSetterForParts("d",null,a,"animate",c,l);this.attr({zIndex:a.zIndexes.group});g!==this.forcedSides&&(this.forcedSides=g,this.renderer.styledMode||h.cuboid.fillSetter.call(this,this.fill))}else w.prototype.animate.call(this,
        a,c,l);return this},fillSetter:function(a){this.forcedSides=this.forcedSides||[];this.singleSetterForParts("fill",null,{front:a,top:r(a).brighten(0<=this.forcedSides.indexOf("top")?0:.1).get(),side:r(a).brighten(0<=this.forcedSides.indexOf("side")?0:-.1).get()});this.color=this.fill=a;return this}});return h});C(a,"Core/Renderer/SVG/SVGRenderer3D.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Math3D.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Renderer/SVG/SVGElement3D.js"],
    a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,w,m,M,k,J,A,G){const {animObject:h}=a,{parse:g}=w,{charts:c,deg2rad:l}=m,{perspective:r,shapeArea:B}=M,{defined:v,extend:F,merge:n,pick:q}=G,D=Math.cos,K=Math.sin,H=Math.PI,N=4*(Math.sqrt(2)-1)/3/(H/2);class I extends A{static compose(f){f=f.prototype;const a=I.prototype;f.elements3d=J;f.arc3d=a.arc3d;f.arc3dPath=a.arc3dPath;f.cuboid=a.cuboid;f.cuboidPath=a.cuboidPath;f.element3d=a.element3d;f.face3d=a.face3d;f.polyhedron=a.polyhedron;
    f.toLinePath=a.toLinePath;f.toLineSegments=a.toLineSegments}static curveTo(a,c,b,p,e,t,d,x){let f=[],y=t-e;return t>e&&t-e>Math.PI/2+.0001?(f=f.concat(this.curveTo(a,c,b,p,e,e+Math.PI/2,d,x)),f=f.concat(this.curveTo(a,c,b,p,e+Math.PI/2,t,d,x))):t<e&&e-t>Math.PI/2+.0001?(f=f.concat(this.curveTo(a,c,b,p,e,e-Math.PI/2,d,x)),f=f.concat(this.curveTo(a,c,b,p,e-Math.PI/2,t,d,x))):[["C",a+b*Math.cos(e)-b*N*y*Math.sin(e)+d,c+p*Math.sin(e)+p*N*y*Math.cos(e)+x,a+b*Math.cos(t)+b*N*y*Math.sin(t)+d,c+p*Math.sin(t)-
p*N*y*Math.cos(t)+x,a+b*Math.cos(t)+d,c+p*Math.sin(t)+x]]}toLinePath(a,c){const b=[];a.forEach(function(a){b.push(["L",a.x,a.y])});a.length&&(b[0][0]="M",c&&b.push(["Z"]));return b}toLineSegments(a){let f=[],b=!0;a.forEach(function(a){f.push(b?["M",a.x,a.y]:["L",a.x,a.y]);b=!b});return f}face3d(a){const f=this,b=this.createElement("path");b.vertexes=[];b.insidePlotArea=!1;b.enabled=!0;b.attr=function(b){if("object"===typeof b&&(v(b.enabled)||v(b.vertexes)||v(b.insidePlotArea))){this.enabled=q(b.enabled,
    this.enabled);this.vertexes=q(b.vertexes,this.vertexes);this.insidePlotArea=q(b.insidePlotArea,this.insidePlotArea);delete b.enabled;delete b.vertexes;delete b.insidePlotArea;var e=r(this.vertexes,c[f.chartIndex],this.insidePlotArea);const a=f.toLinePath(e,!0);e=B(e);b.d=a;b.visibility=this.enabled&&0<e?"inherit":"hidden"}return k.prototype.attr.apply(this,arguments)};b.animate=function(b){if("object"===typeof b&&(v(b.enabled)||v(b.vertexes)||v(b.insidePlotArea))){this.enabled=q(b.enabled,this.enabled);
    this.vertexes=q(b.vertexes,this.vertexes);this.insidePlotArea=q(b.insidePlotArea,this.insidePlotArea);delete b.enabled;delete b.vertexes;delete b.insidePlotArea;var e=r(this.vertexes,c[f.chartIndex],this.insidePlotArea);const a=f.toLinePath(e,!0);e=B(e);e=this.enabled&&0<e?"visible":"hidden";b.d=a;this.attr("visibility",e)}return k.prototype.animate.apply(this,arguments)};return b.attr(a)}polyhedron(a){const f=this,b=this.g(),c=b.destroy;this.styledMode||b.attr({"stroke-linejoin":"round"});b.faces=
    [];b.destroy=function(){for(let e=0;e<b.faces.length;e++)b.faces[e].destroy();return c.call(this)};b.attr=function(e,a,d,x){if("object"===typeof e&&v(e.faces)){for(;b.faces.length>e.faces.length;)b.faces.pop().destroy();for(;b.faces.length<e.faces.length;)b.faces.push(f.face3d().add(b));for(let a=0;a<e.faces.length;a++)f.styledMode&&delete e.faces[a].fill,b.faces[a].attr(e.faces[a],null,d,x);delete e.faces}return k.prototype.attr.apply(this,arguments)};b.animate=function(e,a,d){if(e&&e.faces){for(;b.faces.length>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           e.faces.length;)b.faces.pop().destroy();for(;b.faces.length<e.faces.length;)b.faces.push(f.face3d().add(b));for(let x=0;x<e.faces.length;x++)b.faces[x].animate(e.faces[x],a,d);delete e.faces}return k.prototype.animate.apply(this,arguments)};return b.attr(a)}element3d(a,c){const b=this.g();F(b,this.elements3d[a]);b.initArgs(c);return b}cuboid(a){return this.element3d("cuboid",a)}cuboidPath(a){function f(e){return 0===d&&1<e&&6>e?{x:z[e].x,y:z[e].y+10,z:z[e].z}:z[0].x===z[7].x&&4<=e?{x:z[e].x+10,y:z[e].y,
    z:z[e].z}:0===L&&2>e||5<e?{x:z[e].x,y:z[e].y,z:z[e].z+10}:z[e]}function b(d){return z[d]}let p=a.x||0,e=a.y||0,t=a.z||0,d=a.height||0;var x=a.width||0;let L=a.depth||0,y=c[this.chartIndex];let Q,h,g=y.options.chart.options3d.alpha,O=0,z=[{x:p,y:e,z:t},{x:p+x,y:e,z:t},{x:p+x,y:e+d,z:t},{x:p,y:e+d,z:t},{x:p,y:e+d,z:t+L},{x:p+x,y:e+d,z:t+L},{x:p+x,y:e,z:t+L},{x:p,y:e,z:t+L}],l=[];z=r(z,y,a.insidePlotArea);var k=function(d,e,a){let x=[[],-1],t=d.map(b),c=e.map(b);d=d.map(f);e=e.map(f);0>B(t)?x=[t,0]:
    0>B(c)?x=[c,1]:a&&(l.push(a),x=0>B(d)?[t,0]:0>B(e)?[c,1]:[t,0]);return x};var n=k([3,2,1,0],[7,6,5,4],"front");a=n[0];Q=n[1];n=k([1,6,7,0],[4,5,2,3],"top");x=n[0];h=n[1];n=k([1,2,5,6],[0,7,4,3],"side");k=n[0];n=n[1];1===n?O+=1E6*(y.plotWidth-p):n||(O+=1E6*p);O+=10*(!h||0<=g&&180>=g||360>g&&357.5<g?y.plotHeight-e:10+e);1===Q?O+=100*t:Q||(O+=100*(1E3-t));return{front:this.toLinePath(a,!0),top:this.toLinePath(x,!0),side:this.toLinePath(k,!0),zIndexes:{group:Math.round(O)},forcedSides:l,isFront:Q,isTop:h}}arc3d(a){function c(a){let d=
    !1,b={},c;a=n(a);for(c in a)-1!==e.indexOf(c)&&(b[c]=a[c],delete a[c],d=!0);return d?[b,a]:!1}const b=this.g(),f=b.renderer,e="x y r innerR start end depth".split(" ");a=n(a);a.alpha=(a.alpha||0)*l;a.beta=(a.beta||0)*l;b.top=f.path();b.side1=f.path();b.side2=f.path();b.inn=f.path();b.out=f.path();b.onAdd=function(){const e=b.parentGroup,d=b.attr("class");b.top.add(b);["out","inn","side1","side2"].forEach(function(a){b[a].attr({"class":d+" highcharts-3d-side"}).add(e)})};["addClass","removeClass"].forEach(function(e){b[e]=
    function(){const d=arguments;["top","out","inn","side1","side2"].forEach(function(a){b[a][e].apply(b[a],d)})}});b.setPaths=function(e){const d=b.renderer.arc3dPath(e),a=100*d.zTop;b.attribs=e;b.top.attr({d:d.top,zIndex:d.zTop});b.inn.attr({d:d.inn,zIndex:d.zInn});b.out.attr({d:d.out,zIndex:d.zOut});b.side1.attr({d:d.side1,zIndex:d.zSide1});b.side2.attr({d:d.side2,zIndex:d.zSide2});b.zIndex=a;b.attr({zIndex:a});e.center&&(b.top.setRadialReference(e.center),delete e.center)};b.setPaths(a);b.fillSetter=
    function(e){const d=g(e).brighten(-.1).get();this.fill=e;this.side1.attr({fill:d});this.side2.attr({fill:d});this.inn.attr({fill:d});this.out.attr({fill:d});this.top.attr({fill:e});return this};["opacity","translateX","translateY","visibility"].forEach(function(e){b[e+"Setter"]=function(d,e){b[e]=d;["out","inn","side1","side2","top"].forEach(function(a){b[a].attr(e,d)})}});b.attr=function(e){let d,a;"object"===typeof e&&(a=c(e))&&(d=a[0],arguments[0]=a[1],F(b.attribs,d),b.setPaths(b.attribs));return k.prototype.attr.apply(b,
    arguments)};b.animate=function(e,d,a){let x=this.attribs,f,t,p="data-"+Math.random().toString(26).substring(2,9);delete e.center;delete e.z;delete e.alpha;delete e.beta;t=h(q(d,this.renderer.globalAnimation));t.duration&&(d=c(e),b[p]=0,e[p]=1,b[p+"Setter"]=m.noop,d&&(f=d[0],t.step=function(e,d){function a(e){return x[e]+(q(f[e],x[e])-x[e])*d.pos}d.prop===p&&d.elem.setPaths(n(x,{x:a("x"),y:a("y"),r:a("r"),innerR:a("innerR"),start:a("start"),end:a("end"),depth:a("depth")}))}),d=t);return k.prototype.animate.call(this,
    e,d,a)};b.destroy=function(){this.top.destroy();this.out.destroy();this.inn.destroy();this.side1.destroy();this.side2.destroy();return k.prototype.destroy.call(this)};b.hide=function(){this.top.hide();this.out.hide();this.inn.hide();this.side1.hide();this.side2.hide()};b.show=function(e){this.top.show(e);this.out.show(e);this.inn.show(e);this.side1.show(e);this.side2.show(e)};return b}arc3dPath(a){function c(e){e%=2*Math.PI;e>Math.PI&&(e=2*Math.PI-e);return e}var b=a.x||0,f=a.y||0,e=a.start||0,t=
    (a.end||0)-.00001,d=a.r||0,x=a.innerR||0,L=a.depth||0,y=a.alpha||0,g=a.beta||0,h=Math.cos(e);const k=Math.sin(e);a=Math.cos(t);var l=Math.sin(t);const z=d*Math.cos(g);d*=Math.cos(y);const n=x*Math.cos(g),u=x*Math.cos(y);x=L*Math.sin(g);const q=L*Math.sin(y);L=[["M",b+z*h,f+d*k]];L=L.concat(I.curveTo(b,f,z,d,e,t,0,0));L.push(["L",b+n*a,f+u*l]);L=L.concat(I.curveTo(b,f,n,u,t,e,0,0));L.push(["Z"]);var r=0<g?Math.PI/2:0;g=0<y?0:Math.PI/2;r=e>-r?e:t>-r?-r:e;const v=t<H-g?t:e<H-g?H-g:t,m=2*H-g;y=[["M",
    b+z*D(r),f+d*K(r)]];y=y.concat(I.curveTo(b,f,z,d,r,v,0,0));t>m&&e<m?(y.push(["L",b+z*D(v)+x,f+d*K(v)+q]),y=y.concat(I.curveTo(b,f,z,d,v,m,x,q)),y.push(["L",b+z*D(m),f+d*K(m)]),y=y.concat(I.curveTo(b,f,z,d,m,t,0,0)),y.push(["L",b+z*D(t)+x,f+d*K(t)+q]),y=y.concat(I.curveTo(b,f,z,d,t,m,x,q)),y.push(["L",b+z*D(m),f+d*K(m)]),y=y.concat(I.curveTo(b,f,z,d,m,v,0,0))):t>H-g&&e<H-g&&(y.push(["L",b+z*Math.cos(v)+x,f+d*Math.sin(v)+q]),y=y.concat(I.curveTo(b,f,z,d,v,t,x,q)),y.push(["L",b+z*Math.cos(t),f+d*Math.sin(t)]),
    y=y.concat(I.curveTo(b,f,z,d,t,v,0,0)));y.push(["L",b+z*Math.cos(v)+x,f+d*Math.sin(v)+q]);y=y.concat(I.curveTo(b,f,z,d,v,r,x,q));y.push(["Z"]);g=[["M",b+n*h,f+u*k]];g=g.concat(I.curveTo(b,f,n,u,e,t,0,0));g.push(["L",b+n*Math.cos(t)+x,f+u*Math.sin(t)+q]);g=g.concat(I.curveTo(b,f,n,u,t,e,x,q));g.push(["Z"]);h=[["M",b+z*h,f+d*k],["L",b+z*h+x,f+d*k+q],["L",b+n*h+x,f+u*k+q],["L",b+n*h,f+u*k],["Z"]];b=[["M",b+z*a,f+d*l],["L",b+z*a+x,f+d*l+q],["L",b+n*a+x,f+u*l+q],["L",b+n*a,f+u*l],["Z"]];l=Math.atan2(q,
    -x);f=Math.abs(t+l);a=Math.abs(e+l);e=Math.abs((e+t)/2+l);f=c(f);a=c(a);e=c(e);e*=1E5;t=1E5*a;f*=1E5;return{top:L,zTop:1E5*Math.PI+1,out:y,zOut:Math.max(e,t,f),inn:g,zInn:Math.max(e,t,f),side1:h,zSide1:.99*f,side2:b,zSide2:.99*t}}}return I});C(a,"Core/Chart/Chart3D.js",[a["Core/Color/Color.js"],a["Core/Defaults.js"],a["Core/Math3D.js"],a["Core/Utilities.js"]],function(a,w,m,M){const {parse:k}=a,{defaultOptions:r}=w,{perspective:A,shapeArea3D:G}=m,{addEvent:h,isArray:g,merge:c,pick:l,wrap:P}=M;var B;
    (function(a){function v(e){this.is3d()&&"scatter"===e.options.type&&(e.options.type="scatter3d")}function n(){if(this.chart3d&&this.is3d()){const a=this.renderer;var e=this.options.chart.options3d;const d=this.chart3d.get3dFrame(),b=this.plotLeft,f=this.plotLeft+this.plotWidth,c=this.plotTop,g=this.plotTop+this.plotHeight;e=e.depth;const h=b-(d.left.visible?d.left.size:0),l=f+(d.right.visible?d.right.size:0),p=c-(d.top.visible?d.top.size:0),n=g+(d.bottom.visible?d.bottom.size:0),q=0-(d.front.visible?
        d.front.size:0),u=e+(d.back.visible?d.back.size:0),E=this.hasRendered?"animate":"attr";this.chart3d.frame3d=d;this.frameShapes||(this.frameShapes={bottom:a.polyhedron().add(),top:a.polyhedron().add(),left:a.polyhedron().add(),right:a.polyhedron().add(),back:a.polyhedron().add(),front:a.polyhedron().add()});this.frameShapes.bottom[E]({"class":"highcharts-3d-frame highcharts-3d-frame-bottom",zIndex:d.bottom.frontFacing?-1E3:1E3,faces:[{fill:k(d.bottom.color).brighten(.1).get(),vertexes:[{x:h,y:n,z:q},
                {x:l,y:n,z:q},{x:l,y:n,z:u},{x:h,y:n,z:u}],enabled:d.bottom.visible},{fill:k(d.bottom.color).brighten(.1).get(),vertexes:[{x:b,y:g,z:e},{x:f,y:g,z:e},{x:f,y:g,z:0},{x:b,y:g,z:0}],enabled:d.bottom.visible},{fill:k(d.bottom.color).brighten(-.1).get(),vertexes:[{x:h,y:n,z:q},{x:h,y:n,z:u},{x:b,y:g,z:e},{x:b,y:g,z:0}],enabled:d.bottom.visible&&!d.left.visible},{fill:k(d.bottom.color).brighten(-.1).get(),vertexes:[{x:l,y:n,z:u},{x:l,y:n,z:q},{x:f,y:g,z:0},{x:f,y:g,z:e}],enabled:d.bottom.visible&&!d.right.visible},
            {fill:k(d.bottom.color).get(),vertexes:[{x:l,y:n,z:q},{x:h,y:n,z:q},{x:b,y:g,z:0},{x:f,y:g,z:0}],enabled:d.bottom.visible&&!d.front.visible},{fill:k(d.bottom.color).get(),vertexes:[{x:h,y:n,z:u},{x:l,y:n,z:u},{x:f,y:g,z:e},{x:b,y:g,z:e}],enabled:d.bottom.visible&&!d.back.visible}]});this.frameShapes.top[E]({"class":"highcharts-3d-frame highcharts-3d-frame-top",zIndex:d.top.frontFacing?-1E3:1E3,faces:[{fill:k(d.top.color).brighten(.1).get(),vertexes:[{x:h,y:p,z:u},{x:l,y:p,z:u},{x:l,y:p,z:q},{x:h,
                y:p,z:q}],enabled:d.top.visible},{fill:k(d.top.color).brighten(.1).get(),vertexes:[{x:b,y:c,z:0},{x:f,y:c,z:0},{x:f,y:c,z:e},{x:b,y:c,z:e}],enabled:d.top.visible},{fill:k(d.top.color).brighten(-.1).get(),vertexes:[{x:h,y:p,z:u},{x:h,y:p,z:q},{x:b,y:c,z:0},{x:b,y:c,z:e}],enabled:d.top.visible&&!d.left.visible},{fill:k(d.top.color).brighten(-.1).get(),vertexes:[{x:l,y:p,z:q},{x:l,y:p,z:u},{x:f,y:c,z:e},{x:f,y:c,z:0}],enabled:d.top.visible&&!d.right.visible},{fill:k(d.top.color).get(),vertexes:[{x:h,
                y:p,z:q},{x:l,y:p,z:q},{x:f,y:c,z:0},{x:b,y:c,z:0}],enabled:d.top.visible&&!d.front.visible},{fill:k(d.top.color).get(),vertexes:[{x:l,y:p,z:u},{x:h,y:p,z:u},{x:b,y:c,z:e},{x:f,y:c,z:e}],enabled:d.top.visible&&!d.back.visible}]});this.frameShapes.left[E]({"class":"highcharts-3d-frame highcharts-3d-frame-left",zIndex:d.left.frontFacing?-1E3:1E3,faces:[{fill:k(d.left.color).brighten(.1).get(),vertexes:[{x:h,y:n,z:q},{x:b,y:g,z:0},{x:b,y:g,z:e},{x:h,y:n,z:u}],enabled:d.left.visible&&!d.bottom.visible},
            {fill:k(d.left.color).brighten(.1).get(),vertexes:[{x:h,y:p,z:u},{x:b,y:c,z:e},{x:b,y:c,z:0},{x:h,y:p,z:q}],enabled:d.left.visible&&!d.top.visible},{fill:k(d.left.color).brighten(-.1).get(),vertexes:[{x:h,y:n,z:u},{x:h,y:p,z:u},{x:h,y:p,z:q},{x:h,y:n,z:q}],enabled:d.left.visible},{fill:k(d.left.color).brighten(-.1).get(),vertexes:[{x:b,y:c,z:e},{x:b,y:g,z:e},{x:b,y:g,z:0},{x:b,y:c,z:0}],enabled:d.left.visible},{fill:k(d.left.color).get(),vertexes:[{x:h,y:n,z:q},{x:h,y:p,z:q},{x:b,y:c,z:0},{x:b,y:g,
                    z:0}],enabled:d.left.visible&&!d.front.visible},{fill:k(d.left.color).get(),vertexes:[{x:h,y:p,z:u},{x:h,y:n,z:u},{x:b,y:g,z:e},{x:b,y:c,z:e}],enabled:d.left.visible&&!d.back.visible}]});this.frameShapes.right[E]({"class":"highcharts-3d-frame highcharts-3d-frame-right",zIndex:d.right.frontFacing?-1E3:1E3,faces:[{fill:k(d.right.color).brighten(.1).get(),vertexes:[{x:l,y:n,z:u},{x:f,y:g,z:e},{x:f,y:g,z:0},{x:l,y:n,z:q}],enabled:d.right.visible&&!d.bottom.visible},{fill:k(d.right.color).brighten(.1).get(),
            vertexes:[{x:l,y:p,z:q},{x:f,y:c,z:0},{x:f,y:c,z:e},{x:l,y:p,z:u}],enabled:d.right.visible&&!d.top.visible},{fill:k(d.right.color).brighten(-.1).get(),vertexes:[{x:f,y:c,z:0},{x:f,y:g,z:0},{x:f,y:g,z:e},{x:f,y:c,z:e}],enabled:d.right.visible},{fill:k(d.right.color).brighten(-.1).get(),vertexes:[{x:l,y:n,z:q},{x:l,y:p,z:q},{x:l,y:p,z:u},{x:l,y:n,z:u}],enabled:d.right.visible},{fill:k(d.right.color).get(),vertexes:[{x:l,y:p,z:q},{x:l,y:n,z:q},{x:f,y:g,z:0},{x:f,y:c,z:0}],enabled:d.right.visible&&!d.front.visible},
            {fill:k(d.right.color).get(),vertexes:[{x:l,y:n,z:u},{x:l,y:p,z:u},{x:f,y:c,z:e},{x:f,y:g,z:e}],enabled:d.right.visible&&!d.back.visible}]});this.frameShapes.back[E]({"class":"highcharts-3d-frame highcharts-3d-frame-back",zIndex:d.back.frontFacing?-1E3:1E3,faces:[{fill:k(d.back.color).brighten(.1).get(),vertexes:[{x:l,y:n,z:u},{x:h,y:n,z:u},{x:b,y:g,z:e},{x:f,y:g,z:e}],enabled:d.back.visible&&!d.bottom.visible},{fill:k(d.back.color).brighten(.1).get(),vertexes:[{x:h,y:p,z:u},{x:l,y:p,z:u},{x:f,y:c,
                z:e},{x:b,y:c,z:e}],enabled:d.back.visible&&!d.top.visible},{fill:k(d.back.color).brighten(-.1).get(),vertexes:[{x:h,y:n,z:u},{x:h,y:p,z:u},{x:b,y:c,z:e},{x:b,y:g,z:e}],enabled:d.back.visible&&!d.left.visible},{fill:k(d.back.color).brighten(-.1).get(),vertexes:[{x:l,y:p,z:u},{x:l,y:n,z:u},{x:f,y:g,z:e},{x:f,y:c,z:e}],enabled:d.back.visible&&!d.right.visible},{fill:k(d.back.color).get(),vertexes:[{x:b,y:c,z:e},{x:f,y:c,z:e},{x:f,y:g,z:e},{x:b,y:g,z:e}],enabled:d.back.visible},{fill:k(d.back.color).get(),
            vertexes:[{x:h,y:n,z:u},{x:l,y:n,z:u},{x:l,y:p,z:u},{x:h,y:p,z:u}],enabled:d.back.visible}]});this.frameShapes.front[E]({"class":"highcharts-3d-frame highcharts-3d-frame-front",zIndex:d.front.frontFacing?-1E3:1E3,faces:[{fill:k(d.front.color).brighten(.1).get(),vertexes:[{x:h,y:n,z:q},{x:l,y:n,z:q},{x:f,y:g,z:0},{x:b,y:g,z:0}],enabled:d.front.visible&&!d.bottom.visible},{fill:k(d.front.color).brighten(.1).get(),vertexes:[{x:l,y:p,z:q},{x:h,y:p,z:q},{x:b,y:c,z:0},{x:f,y:c,z:0}],enabled:d.front.visible&&
                !d.top.visible},{fill:k(d.front.color).brighten(-.1).get(),vertexes:[{x:h,y:p,z:q},{x:h,y:n,z:q},{x:b,y:g,z:0},{x:b,y:c,z:0}],enabled:d.front.visible&&!d.left.visible},{fill:k(d.front.color).brighten(-.1).get(),vertexes:[{x:l,y:n,z:q},{x:l,y:p,z:q},{x:f,y:c,z:0},{x:f,y:g,z:0}],enabled:d.front.visible&&!d.right.visible},{fill:k(d.front.color).get(),vertexes:[{x:f,y:c,z:0},{x:b,y:c,z:0},{x:b,y:g,z:0},{x:f,y:g,z:0}],enabled:d.front.visible},{fill:k(d.front.color).get(),vertexes:[{x:l,y:n,z:q},{x:h,y:n,
                z:q},{x:h,y:p,z:q},{x:l,y:p,z:q}],enabled:d.front.visible}]})}}function q(){this.styledMode&&[{name:"darker",slope:.6},{name:"brighter",slope:1.4}].forEach(function(e){this.renderer.definition({tagName:"filter",attributes:{id:"highcharts-"+e.name},children:[{tagName:"feComponentTransfer",children:[{tagName:"feFuncR",attributes:{type:"linear",slope:e.slope}},{tagName:"feFuncG",attributes:{type:"linear",slope:e.slope}},{tagName:"feFuncB",attributes:{type:"linear",slope:e.slope}}]}]})},this)}function m(){const e=
        this.options;this.is3d()&&(e.series||[]).forEach(function(a){"scatter"===(a.type||e.chart.type||e.chart.defaultSeriesType)&&(a.type="scatter3d")})}function K(){const a=this.options.chart.options3d;if(this.chart3d&&this.is3d()){a&&(a.alpha=a.alpha%360+(0<=a.alpha?0:360),a.beta=a.beta%360+(0<=a.beta?0:360));const e=this.inverted,d=this.clipBox,b=this.margin,f=e?"x":"y",c=e?"height":"width",g=e?"width":"height";d[e?"y":"x"]=-(b[3]||0);d[f]=-(b[0]||0);d[c]=this.chartWidth+(b[3]||0)+(b[1]||0);d[g]=this.chartHeight+
        (b[0]||0)+(b[2]||0);this.scale3d=1;!0===a.fitToPlot&&(this.scale3d=this.chart3d.getScale(a.depth));this.chart3d.frame3d=this.chart3d.get3dFrame()}}function H(){this.is3d()&&(this.isDirtyBox=!0)}function B(){this.chart3d&&this.is3d()&&(this.chart3d.frame3d=this.chart3d.get3dFrame())}function I(){this.chart3d||(this.chart3d=new p(this))}function f(a){return this.is3d()||a.apply(this,[].slice.call(arguments,1))}function E(a){let e=this.series.length;if(this.is3d())for(;e--;)a=this.series[e],a.translate(),
        a.render();else a.call(this)}function b(a){a.apply(this,[].slice.call(arguments,1));this.is3d()&&(this.container.className+=" highcharts-3d-chart")}class p{constructor(a){this.frame3d=void 0;this.chart=a}get3dFrame(){const a=this.chart;var b=a.options.chart.options3d,d=b.frame,f=a.plotLeft;const c=a.plotLeft+a.plotWidth,g=a.plotTop;var h=a.plotTop+a.plotHeight;const p=b.depth;var n=function(b){b=G(b,a);return.5<b?1:-.5>b?-1:0},q=n([{x:f,y:h,z:p},{x:c,y:h,z:p},{x:c,y:h,z:0},{x:f,y:h,z:0}]),k=n([{x:f,
        y:g,z:0},{x:c,y:g,z:0},{x:c,y:g,z:p},{x:f,y:g,z:p}]),E=n([{x:f,y:g,z:0},{x:f,y:g,z:p},{x:f,y:h,z:p},{x:f,y:h,z:0}]),u=n([{x:c,y:g,z:p},{x:c,y:g,z:0},{x:c,y:h,z:0},{x:c,y:h,z:p}]);const H=n([{x:f,y:h,z:0},{x:c,y:h,z:0},{x:c,y:g,z:0},{x:f,y:g,z:0}]);n=n([{x:f,y:g,z:p},{x:c,y:g,z:p},{x:c,y:h,z:p},{x:f,y:h,z:p}]);let r=!1,v=!1,m=!1,K=!1;[].concat(a.xAxis,a.yAxis,a.zAxis).forEach(function(a){a&&(a.horiz?a.opposite?v=!0:r=!0:a.opposite?K=!0:m=!0)});const D=function(a,b,d){const e=["size","color","visible"],
        f={};for(let b=0;b<e.length;b++){const d=e[b];for(let b=0;b<a.length;b++)if("object"===typeof a[b]){const e=a[b][d];if("undefined"!==typeof e&&null!==e){f[d]=e;break}}}a=d;!0===f.visible||!1===f.visible?a=f.visible:"auto"===f.visible&&(a=0<b);return{size:l(f.size,1),color:l(f.color,"none"),frontFacing:0<b,visible:a}};d={axes:{},bottom:D([d.bottom,d.top,d],q,r),top:D([d.top,d.bottom,d],k,v),left:D([d.left,d.right,d.side,d],E,m),right:D([d.right,d.left,d.side,d],u,K),back:D([d.back,d.front,d],n,!0),
        front:D([d.front,d.back,d],H,!1)};"auto"===b.axisLabelPosition?(u=function(a,b){return a.visible!==b.visible||a.visible&&b.visible&&a.frontFacing!==b.frontFacing},b=[],u(d.left,d.front)&&b.push({y:(g+h)/2,x:f,z:0,xDir:{x:1,y:0,z:0}}),u(d.left,d.back)&&b.push({y:(g+h)/2,x:f,z:p,xDir:{x:0,y:0,z:-1}}),u(d.right,d.front)&&b.push({y:(g+h)/2,x:c,z:0,xDir:{x:0,y:0,z:1}}),u(d.right,d.back)&&b.push({y:(g+h)/2,x:c,z:p,xDir:{x:-1,y:0,z:0}}),q=[],u(d.bottom,d.front)&&q.push({x:(f+c)/2,y:h,z:0,xDir:{x:1,y:0,z:0}}),
    u(d.bottom,d.back)&&q.push({x:(f+c)/2,y:h,z:p,xDir:{x:-1,y:0,z:0}}),k=[],u(d.top,d.front)&&k.push({x:(f+c)/2,y:g,z:0,xDir:{x:1,y:0,z:0}}),u(d.top,d.back)&&k.push({x:(f+c)/2,y:g,z:p,xDir:{x:-1,y:0,z:0}}),E=[],u(d.bottom,d.left)&&E.push({z:(0+p)/2,y:h,x:f,xDir:{x:0,y:0,z:-1}}),u(d.bottom,d.right)&&E.push({z:(0+p)/2,y:h,x:c,xDir:{x:0,y:0,z:1}}),h=[],u(d.top,d.left)&&h.push({z:(0+p)/2,y:g,x:f,xDir:{x:0,y:0,z:-1}}),u(d.top,d.right)&&h.push({z:(0+p)/2,y:g,x:c,xDir:{x:0,y:0,z:1}}),f=function(b,d,e){if(0===
        b.length)return null;if(1===b.length)return b[0];const f=A(b,a,!1);let c=0;for(let a=1;a<f.length;a++)e*f[a][d]>e*f[c][d]?c=a:e*f[a][d]===e*f[c][d]&&f[a].z<f[c].z&&(c=a);return b[c]},d.axes={y:{left:f(b,"x",-1),right:f(b,"x",1)},x:{top:f(k,"y",-1),bottom:f(q,"y",1)},z:{top:f(h,"y",-1),bottom:f(E,"y",1)}}):d.axes={y:{left:{x:f,z:0,xDir:{x:1,y:0,z:0}},right:{x:c,z:0,xDir:{x:0,y:0,z:1}}},x:{top:{y:g,z:0,xDir:{x:1,y:0,z:0}},bottom:{y:h,z:0,xDir:{x:1,y:0,z:0}}},z:{top:{x:m?c:f,y:g,xDir:m?{x:0,y:0,z:1}:
                    {x:0,y:0,z:-1}},bottom:{x:m?c:f,y:h,xDir:m?{x:0,y:0,z:1}:{x:0,y:0,z:-1}}}};return d}getScale(a){const b=this.chart,d=b.plotLeft,e=b.plotWidth+d,f=b.plotTop,c=b.plotHeight+f,g=d+b.plotWidth/2,h=f+b.plotHeight/2;var p=Number.MAX_VALUE,n=-Number.MAX_VALUE,l=Number.MAX_VALUE,q=-Number.MAX_VALUE;let k,E=1;k=[{x:d,y:f,z:0},{x:d,y:f,z:a}];[0,1].forEach(function(a){k.push({x:e,y:k[a].y,z:k[a].z})});[0,1,2,3].forEach(function(a){k.push({x:k[a].x,y:c,z:k[a].z})});k=A(k,b,!1);k.forEach(function(a){p=Math.min(p,
        a.x);n=Math.max(n,a.x);l=Math.min(l,a.y);q=Math.max(q,a.y)});d>p&&(E=Math.min(E,1-Math.abs((d+g)/(p+g))%1));e<n&&(E=Math.min(E,(e-g)/(n-g)));f>l&&(E=0>l?Math.min(E,(f+h)/(-l+f+h)):Math.min(E,1-(f+h)/(l+h)%1));c<q&&(E=Math.min(E,Math.abs((c-h)/(q-h))));return E}}a.Composition=p;a.defaultOptions={chart:{options3d:{enabled:!1,alpha:0,beta:0,depth:100,fitToPlot:!0,viewDistance:25,axisLabelPosition:null,frame:{visible:"default",size:1,bottom:{},top:{},left:{},right:{},back:{},front:{}}}}};a.compose=function(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    p){const d=e.prototype;p=p.prototype;d.is3d=function(){return!(!this.options.chart.options3d||!this.options.chart.options3d.enabled)};d.propsRequireDirtyBox.push("chart.options3d");d.propsRequireUpdateSeries.push("chart.options3d");p.matrixSetter=function(){let a;if(1>this.pos&&(g(this.start)||g(this.end))){const b=this.start||[1,0,0,1,0,0],d=this.end||[1,0,0,1,0,0];a=[];for(let e=0;6>e;e++)a.push(this.pos*d[e]+(1-this.pos)*b[e])}else a=this.end;this.elem.attr(this.prop,a,null,!0)};c(!0,r,a.defaultOptions);
        h(e,"init",I);h(e,"addSeries",v);h(e,"afterDrawChartBox",n);h(e,"afterGetContainer",q);h(e,"afterInit",m);h(e,"afterSetChartSize",K);h(e,"beforeRedraw",H);h(e,"beforeRender",B);P(d,"isInsidePlot",f);P(d,"renderSeries",E);P(d,"setClassName",b)}})(B||(B={}));"";return B});C(a,"Core/Axis/ZAxis.js",[a["Core/Axis/Axis.js"],a["Core/Utilities.js"]],function(a,w){function m(a){return new g(this,a)}function r(){const a=this.options.zAxis=G(this.options.zAxis||{});this.is3d()&&(this.zAxis=[],a.forEach((a,c)=>
{a.index=c;a.isX=!0;this.addZAxis(a).setScale()}))}const {addEvent:k,merge:J,pick:A,splat:G}=w,h=[];class g extends a{static compose(a){w.pushUnique(h,a)&&(k(a,"afterGetAxes",r),a=a.prototype,a.addZAxis=m,a.collectionsWithInit.zAxis=[a.addZAxis],a.collectionsWithUpdate.push("zAxis"))}constructor(a,g){super(a,g);this.isZAxis=!0}getSeriesExtremes(){const a=this.chart;this.hasVisibleSeries=!1;this.dataMin=this.dataMax=this.ignoreMinPadding=this.ignoreMaxPadding=void 0;this.stacking&&this.stacking.buildStacks();
    this.series.forEach(c=>{if(c.visible||!a.options.chart.ignoreHiddenSeries)this.hasVisibleSeries=!0,c=c.zData,c.length&&(this.dataMin=Math.min(A(this.dataMin,c[0]),Math.min.apply(null,c)),this.dataMax=Math.max(A(this.dataMax,c[0]),Math.max.apply(null,c)))})}setAxisSize(){const a=this.chart;super.setAxisSize();this.width=this.len=a.options.chart.options3d&&a.options.chart.options3d.depth||0;this.right=a.chartWidth-this.width-this.left}setOptions(a){a=J({offset:0,lineWidth:0},a);this.isZAxis=!0;super.setOptions(a);
    this.coll="zAxis"}}return g});C(a,"Core/Axis/Axis3DDefaults.js",[],function(){return{labels:{position3d:"offset",skew3d:!1},title:{position3d:null,skew3d:null}}});C(a,"Core/Axis/Tick3DComposition.js",[a["Core/Utilities.js"]],function(a){function r(a){const h=this.axis.axis3D;h&&k(a.pos,h.fix3dPosition(a.pos))}function m(a){var h=this.axis.axis3D;const g=a.apply(this,[].slice.call(arguments,1));if(h){const a=g[0],l=g[1];if("M"===a[0]&&"L"===l[0])return h=[h.fix3dPosition({x:a[1],y:a[2],z:0}),h.fix3dPosition({x:l[1],
    y:l[2],z:0})],this.axis.chart.renderer.toLineSegments(h)}return g}const {addEvent:M,extend:k,wrap:J}=a,A=[];return{compose:function(k){a.pushUnique(A,k)&&(M(k,"afterGetLabelPosition",r),J(k.prototype,"getMarkPath",m))}}});C(a,"Core/Axis/Axis3DComposition.js",[a["Core/Axis/Axis3DDefaults.js"],a["Core/Globals.js"],a["Core/Math3D.js"],a["Core/Axis/Tick3DComposition.js"],a["Core/Utilities.js"]],function(a,w,m,M,k){function r(){const a=this.chart,c=this.options;a.is3d&&a.is3d()&&"colorAxis"!==this.coll&&
(c.tickWidth=K(c.tickWidth,0),c.gridLineWidth=K(c.gridLineWidth,1))}function A(a){this.chart.is3d()&&"colorAxis"!==this.coll&&a.point&&(a.point.crosshairPos=this.isXAxis?a.point.axisXpos:this.len-a.point.axisYpos)}function G(){this.axis3D||(this.axis3D=new I(this))}function h(a){return this.chart.is3d()&&"colorAxis"!==this.coll?[]:a.apply(this,[].slice.call(arguments,1))}function g(a){if(!this.chart.is3d()||"colorAxis"===this.coll)return a.apply(this,[].slice.call(arguments,1));var f=arguments,b=
    f[2];const c=[];f=this.getPlotLinePath({value:f[1]});b=this.getPlotLinePath({value:b});if(f&&b)for(let a=0;a<f.length;a+=2){const e=f[a],d=f[a+1],g=b[a],h=b[a+1];"M"===e[0]&&"L"===d[0]&&"M"===g[0]&&"L"===h[0]&&c.push(e,d,h,["L",g[1],g[2]],["Z"])}return c}function c(a){var f=this.axis3D;const b=this.chart;var c=a.apply(this,[].slice.call(arguments,1));if("colorAxis"===this.coll||!b.chart3d||!b.is3d()||null===c)return c;var e=b.options.chart.options3d;const g=this.isZAxis?b.plotWidth:e.depth;e=b.chart3d.frame3d;
    const d=c[0],h=c[1];c=[];"M"===d[0]&&"L"===h[0]&&(f=[f.swapZ({x:d[1],y:d[2],z:0}),f.swapZ({x:d[1],y:d[2],z:g}),f.swapZ({x:h[1],y:h[2],z:0}),f.swapZ({x:h[1],y:h[2],z:g})],this.horiz?(this.isZAxis?(e.left.visible&&c.push(f[0],f[2]),e.right.visible&&c.push(f[1],f[3])):(e.front.visible&&c.push(f[0],f[2]),e.back.visible&&c.push(f[1],f[3])),e.top.visible&&c.push(f[0],f[1]),e.bottom.visible&&c.push(f[2],f[3])):(e.front.visible&&c.push(f[0],f[2]),e.back.visible&&c.push(f[1],f[3]),e.left.visible&&c.push(f[0],
        f[1]),e.right.visible&&c.push(f[2],f[3])),c=v(c,this.chart,!1));return b.renderer.toLineSegments(c)}function l(a,c){var b=this.chart,f=this.ticks,e=this.gridGroup;if(this.categories&&b.frameShapes&&b.is3d()&&e&&c&&c.label){e=e.element.childNodes[0].getBBox();const a=b.frameShapes.left.getBBox();var g=b.options.chart.options3d;b={x:b.plotWidth/2,y:b.plotHeight/2,z:g.depth/2,vd:K(g.depth,1)*K(g.viewDistance,0)};g=c.pos;const h=f[g-1];f=f[g+1];let n,p;0!==g&&h&&h.label&&h.label.xy&&(n=F({x:h.label.xy.x,
    y:h.label.xy.y,z:null},b,b.vd));f&&f.label&&f.label.xy&&(p=F({x:f.label.xy.x,y:f.label.xy.y,z:null},b,b.vd));f={x:c.label.xy.x,y:c.label.xy.y,z:null};f=F(f,b,b.vd);return Math.abs(n?f.x-n.x:p?p.x-f.x:e.x-a.x)}return a.apply(this,[].slice.call(arguments,1))}function P(a){const f=a.apply(this,[].slice.call(arguments,1));return this.axis3D?this.axis3D.fix3dPosition(f,!0):f}const {deg2rad:B}=w,{perspective:v,perspective3D:F,shapeArea:n}=m,{addEvent:q,merge:D,pick:K,wrap:H}=k,N=[];class I{static compose(f,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            n){M.compose(n);k.pushUnique(N,f)&&(D(!0,f.defaultOptions,a),f.keepProps.push("axis3D"),q(f,"init",G),q(f,"afterSetOptions",r),q(f,"drawCrosshair",A),f=f.prototype,H(f,"getLinePath",h),H(f,"getPlotBandPath",g),H(f,"getPlotLinePath",c),H(f,"getSlotWidth",l),H(f,"getTitlePosition",P))}constructor(a){this.axis=a}fix3dPosition(a,c){const b=this.axis;var f=b.chart;if("colorAxis"===b.coll||!f.chart3d||!f.is3d())return a;var e=B*f.options.chart.options3d.alpha,g=B*f.options.chart.options3d.beta,d=K(c&&b.options.title.position3d,
    b.options.labels.position3d);c=K(c&&b.options.title.skew3d,b.options.labels.skew3d);const h=f.chart3d.frame3d;var l=f.plotLeft;const q=f.plotWidth+l,k=f.plotTop,H=f.plotHeight+k;let r=f=0;var m={x:0,y:1,z:0};let D=!1;a=b.axis3D.swapZ({x:a.x,y:a.y,z:0});if(b.isZAxis)if(b.opposite){if(null===h.axes.z.top)return{};r=a.y-k;a.x=h.axes.z.top.x;a.y=h.axes.z.top.y;l=h.axes.z.top.xDir;D=!h.top.frontFacing}else{if(null===h.axes.z.bottom)return{};r=a.y-H;a.x=h.axes.z.bottom.x;a.y=h.axes.z.bottom.y;l=h.axes.z.bottom.xDir;
    D=!h.bottom.frontFacing}else if(b.horiz)if(b.opposite){if(null===h.axes.x.top)return{};r=a.y-k;a.y=h.axes.x.top.y;a.z=h.axes.x.top.z;l=h.axes.x.top.xDir;D=!h.top.frontFacing}else{if(null===h.axes.x.bottom)return{};r=a.y-H;a.y=h.axes.x.bottom.y;a.z=h.axes.x.bottom.z;l=h.axes.x.bottom.xDir;D=!h.bottom.frontFacing}else if(b.opposite){if(null===h.axes.y.right)return{};f=a.x-q;a.x=h.axes.y.right.x;a.z=h.axes.y.right.z;l=h.axes.y.right.xDir;l={x:l.z,y:l.y,z:-l.x}}else{if(null===h.axes.y.left)return{};f=
    a.x-l;a.x=h.axes.y.left.x;a.z=h.axes.y.left.z;l=h.axes.y.left.xDir}"chart"!==d&&("flap"===d?b.horiz?(g=Math.sin(e),e=Math.cos(e),b.opposite&&(g=-g),D&&(g=-g),m={x:l.z*g,y:e,z:-l.x*g}):l={x:Math.cos(g),y:0,z:Math.sin(g)}:"ortho"===d?b.horiz?(m=Math.cos(e),d=Math.sin(g)*m,e=-Math.sin(e),g=-m*Math.cos(g),m={x:l.y*g-l.z*e,y:l.z*d-l.x*g,z:l.x*e-l.y*d},e=1/Math.sqrt(m.x*m.x+m.y*m.y+m.z*m.z),D&&(e=-e),m={x:e*m.x,y:e*m.y,z:e*m.z}):l={x:Math.cos(g),y:0,z:Math.sin(g)}:b.horiz?m={x:Math.sin(g)*Math.sin(e),y:Math.cos(e),
    z:-Math.cos(g)*Math.sin(e)}:l={x:Math.cos(g),y:0,z:Math.sin(g)});a.x+=f*l.x+r*m.x;a.y+=f*l.y+r*m.y;a.z+=f*l.z+r*m.z;f=v([a],b.chart)[0];c&&(0>n(v([a,{x:a.x+l.x,y:a.y+l.y,z:a.z+l.z},{x:a.x+m.x,y:a.y+m.y,z:a.z+m.z}],b.chart))&&(l={x:-l.x,y:-l.y,z:-l.z}),a=v([{x:a.x,y:a.y,z:a.z},{x:a.x+l.x,y:a.y+l.y,z:a.z+l.z},{x:a.x+m.x,y:a.y+m.y,z:a.z+m.z}],b.chart),f.matrix=[a[1].x-a[0].x,a[1].y-a[0].y,a[2].x-a[0].x,a[2].y-a[0].y,f.x,f.y],f.matrix[4]-=f.x*f.matrix[0]+f.y*f.matrix[2],f.matrix[5]-=f.x*f.matrix[1]+f.y*
    f.matrix[3]);return f}swapZ(a,c){const b=this.axis;return b.isZAxis?(c=c?0:b.chart.plotLeft,{x:c+a.z,y:a.y,z:a.x-c}):a}}return I});C(a,"Core/Series/Series3D.js",[a["Core/Math3D.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,w,m){const {perspective:r}=a,{addEvent:k,extend:J,merge:A,pick:G,isNumber:h}=m;class g extends w{translate(){super.translate.apply(this,arguments);this.chart.is3d()&&this.translate3dPoints()}translate3dPoints(){var a=this.options,g=this.chart,k=G(this.zAxis,
    g.options.zAxis[0]);let m=[],v,w,n=[];this.zPadding=(a.stacking?h(a.stack)?a.stack:0:this.index||0)*(a.depth||0+(a.groupZPadding||1));for(w=0;w<this.data.length;w++)a=this.data[w],k&&k.translate?(v=k.logarithmic&&k.val2lin?k.val2lin(a.z):a.z,a.plotZ=k.translate(v),a.isInside=a.isInside?v>=k.min&&v<=k.max:!1):a.plotZ=this.zPadding,a.axisXpos=a.plotX,a.axisYpos=a.plotY,a.axisZpos=a.plotZ,m.push({x:a.plotX,y:a.plotY,z:a.plotZ}),n.push(a.plotX||0);this.rawPointsX=n;g=r(m,g,!0);for(w=0;w<this.data.length;w++)a=
    this.data[w],k=g[w],a.plotX=k.x,a.plotY=k.y,a.plotZ=k.z}}g.defaultOptions=A(w.defaultOptions);k(w,"afterTranslate",function(){this.chart.is3d()&&this.translate3dPoints()});J(w.prototype,{translate3dPoints:g.prototype.translate3dPoints});return g});C(a,"Series/Area3D/Area3DSeries.js",[a["Core/Math3D.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,w,m){function r(a){const g=a.apply(this,[].slice.call(arguments,1));if(!this.chart.is3d())return g;var c=J.getGraphPath,h=this.options;
    const m=Math.round(this.yAxis.getThreshold(h.threshold));let r=[];if(this.rawPointsX)for(let a=0;a<this.points.length;a++)r.push({x:this.rawPointsX[a],y:h.stacking?this.points[a].yBottom:m,z:this.zPadding});h=this.chart.options.chart.options3d;r=k(r,this.chart,!0).map(a=>({plotX:a.x,plotY:a.y,plotZ:a.z}));this.group&&h&&h.depth&&h.beta&&(this.markerGroup&&(this.markerGroup.add(this.group),this.markerGroup.attr({translateX:0,translateY:0})),this.group.attr({zIndex:Math.max(1,270<h.beta||90>h.beta?
            h.depth-Math.round(this.zPadding||0):Math.round(this.zPadding||0))}));r.reversed=!0;c=c.call(this,r,!0,!0);c[0]&&"M"===c[0][0]&&(c[0]=["L",c[0][1],c[0][2]]);this.areaPath&&(c=this.areaPath.splice(0,this.areaPath.length/2).concat(c),c.xMap=this.areaPath.xMap,this.areaPath=c);return g}const {perspective:k}=a,{seriesTypes:{line:{prototype:J}}}=w,{wrap:A}=m,G=[];return{compose:function(a){m.pushUnique(G,a)&&A(a.prototype,"getGraphPath",r)}}});C(a,"Series/Column3D/Column3DComposition.js",[a["Series/Column/ColumnSeries.js"],
    a["Core/Series/Series.js"],a["Core/Math3D.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Axis/Stacking/StackItem.js"],a["Core/Utilities.js"]],function(a,w,m,M,k,J){function r(a,c){const g=a.series,h={totalStacks:0};let n,l=1;g.forEach(function(a){n=v(a.options.stack,c?0:g.length-1-a.index);h[n]?h[n].series.push(a):(h[n]={series:[a],position:l},l++)});h.totalStacks=l+1;return h}function G(a){const c=a.apply(this,[].slice.call(arguments,1));this.chart.is3d&&this.chart.is3d()&&(c.stroke=this.options.edgeColor||
    c.fill,c["stroke-width"]=v(this.options.edgeWidth,1));return c}function h(a,c,h){const g=this.chart.is3d&&this.chart.is3d();g&&(this.options.inactiveOtherPoints=!0);a.call(this,c,h);g&&(this.options.inactiveOtherPoints=!1)}function g(a,...c){return this.series.chart.is3d()?this.graphic&&"g"!==this.graphic.element.nodeName:a.apply(this,c)}const {prototype:c}=a,{perspective:l}=m,{addEvent:C,extend:B,pick:v,wrap:F}=J;F(c,"translate",function(a){a.apply(this,[].slice.call(arguments,1));this.chart.is3d()&&
this.translate3dShapes()});F(w.prototype,"justifyDataLabel",function(a){return arguments[2].outside3dPlot?!1:a.apply(this,[].slice.call(arguments,1))});c.translate3dPoints=function(){};c.translate3dShapes=function(){let a=this,c=a.chart,g=a.options,h=g.depth,k=(g.stacking?g.stack||0:a.index)*(h+(g.groupZPadding||1)),m=a.borderWidth%2?.5:0,r;c.inverted&&!a.yAxis.reversed&&(m*=-1);!1!==g.grouping&&(k=0);k+=g.groupZPadding||1;a.data.forEach(function(f){f.outside3dPlot=null;if(null!==f.y){const b=B({x:0,
    y:0,width:0,height:0},f.shapeArgs||{});var g=f.tooltipPos;let n;[["x","width"],["y","height"]].forEach(e=>{n=b[e[0]]-m;0>n&&(b[e[1]]+=b[e[0]]+m,b[e[0]]=-m,n=0);n+b[e[1]]>a[e[0]+"Axis"].len&&0!==b[e[1]]&&(b[e[1]]=a[e[0]+"Axis"].len-b[e[0]]);if(0!==b[e[1]]&&(b[e[0]]>=a[e[0]+"Axis"].len||b[e[0]]+b[e[1]]<=m)){for(const a in b)b[a]="y"===a?-9999:0;f.outside3dPlot=!0}});"roundedRect"===f.shapeType&&(f.shapeType="cuboid");f.shapeArgs=B(b,{z:k,depth:h,insidePlotArea:!0});r={x:b.x+b.width/2,y:b.y,z:k+h/2};
    c.inverted&&(r.x=b.height,r.y=f.clientX||0);f.plot3d=l([r],c,!0,!1)[0];g&&(g=l([{x:g[0],y:g[1],z:k+h/2}],c,!0,!1)[0],f.tooltipPos=[g.x,g.y])}});a.z=k};F(c,"animate",function(a){if(this.chart.is3d()){const a=this.yAxis,c=this,g=this.yAxis.reversed;arguments[1]?c.data.forEach(function(c){null!==c.y&&(c.height=c.shapeArgs.height,c.shapey=c.shapeArgs.y,c.shapeArgs.height=1,g||(c.shapeArgs.y=c.stackY?c.plotY+a.translate(c.stackY):c.plotY+(c.negative?-c.height:c.height)))}):(c.data.forEach(function(a){if(null!==
    a.y&&(a.shapeArgs.height=a.height,a.shapeArgs.y=a.shapey,a.graphic))a.graphic[a.outside3dPlot?"attr":"animate"](a.shapeArgs,c.options.animation)}),this.drawDataLabels())}else a.apply(this,[].slice.call(arguments,1))});F(c,"plotGroup",function(a,c,g,h,l,k){"dataLabelsGroup"!==c&&"markerGroup"!==c&&this.chart.is3d()&&(this[c]&&delete this[c],k&&(this.chart.columnGroup||(this.chart.columnGroup=this.chart.renderer.g("columnGroup").add(k)),this[c]=this.chart.columnGroup,this.chart.columnGroup.attr(this.getPlotBox()),
    this[c].survive=!0,"group"===c&&(arguments[3]="visible")));return a.apply(this,Array.prototype.slice.call(arguments,1))});F(c,"setVisible",function(a,c){const g=this;g.chart.is3d()&&g.data.forEach(function(a){a.visible=a.options.visible=c="undefined"===typeof c?!v(g.visible,a.visible):c;g.options.data[g.data.indexOf(a)]=a.options;a.graphic&&a.graphic.attr({visibility:c?"visible":"hidden"})});a.apply(this,Array.prototype.slice.call(arguments,1))});C(a,"afterInit",function(){if(this.chart.is3d()){let h=
    this.options;var a=h.grouping,c=h.stacking;let l=this.yAxis.options.reversedStacks;var g=0;if("undefined"===typeof a||a){a=r(this.chart,c);g=h.stack||0;for(c=0;c<a[g].series.length&&a[g].series[c]!==this;c++);g=10*(a.totalStacks-a[g].position)+(l?c:-c);this.xAxis.reversed||(g=10*a.totalStacks-g)}h.depth=h.depth||25;this.z=this.z||0;h.zIndex=g}});F(c,"pointAttribs",G);F(c,"setState",h);F(c.pointClass.prototype,"hasNewShapeType",g);M.seriesTypes.columnRange&&(m=M.seriesTypes.columnrange.prototype,F(m,
    "pointAttribs",G),F(m,"setState",h),F(m.pointClass.prototype,"hasNewShapeType",g),m.plotGroup=c.plotGroup,m.setVisible=c.setVisible);F(w.prototype,"alignDataLabel",function(a,c,g,h,k){const n=this.chart;h.outside3dPlot=c.outside3dPlot;if(n.is3d()&&this.is("column")){var m=this.options;const a=v(h.inside,!!this.options.stacking),g=n.options.chart.options3d,b=c.pointWidth/2||0;m={x:k.x+b,y:k.y,z:this.z+m.depth/2};n.inverted&&(a&&(k.width=0,m.x+=c.shapeArgs.height/2),90<=g.alpha&&270>=g.alpha&&(m.y+=
    c.shapeArgs.width));m=l([m],n,!0,!1)[0];k.x=m.x-b;k.y=c.outside3dPlot?-9E9:m.y}a.apply(this,[].slice.call(arguments,1))});F(k.prototype,"getStackBox",function(a,c){const g=a.apply(this,[].slice.call(arguments,1)),h=this.axis.chart,{width:k}=c;if(h.is3d()&&this.base){var n=+this.base.split(",")[0],m=h.series[n];n=h.options.chart.options3d;m&&m instanceof M.seriesTypes.column&&(m={x:g.x+(h.inverted?g.height:k/2),y:g.y,z:m.options.depth/2},h.inverted&&(g.width=0,90<=n.alpha&&270>=n.alpha&&(m.y+=k)),
    m=l([m],h,!0,!1)[0],g.x=m.x-k/2,g.y=m.y)}return g});"";return a});C(a,"Series/Pie3D/Pie3DPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){({seriesTypes:{pie:{prototype:{pointClass:a}}}}=a);const r=a.prototype.haloPath;class m extends a{constructor(){super(...arguments);this.series=void 0}haloPath(){var a;return(null===(a=this.series)||void 0===a?0:a.chart.is3d())?[]:r.apply(this,arguments)}}return m});C(a,"Series/Pie3D/Pie3DSeries.js",[a["Core/Globals.js"],a["Series/Pie3D/Pie3DPoint.js"],
    a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,w,m,C){const {deg2rad:k}=a;({seriesTypes:{pie:a}}=m);const {extend:r,pick:A}=C;class G extends a{addPoint(){super.addPoint.apply(this,arguments);this.chart.is3d()&&this.update(this.userOptions,!0)}animate(a){if(this.chart.is3d()){let c=this.options.animation;var g=this.center;let h=this.group,k=this.markerGroup;!0===c&&(c={});a?(h.oldtranslateX=A(h.oldtranslateX,h.translateX),h.oldtranslateY=A(h.oldtranslateY,h.translateY),g={translateX:g[0],
    translateY:g[1],scaleX:.001,scaleY:.001},h.attr(g),k&&(k.attrSetters=h.attrSetters,k.attr(g))):(g={translateX:h.oldtranslateX,translateY:h.oldtranslateY,scaleX:1,scaleY:1},h.animate(g,c),k&&k.animate(g,c))}else super.animate.apply(this,arguments)}drawDataLabels(){if(this.chart.is3d()){const a=this.chart.options.chart.options3d;this.data.forEach(function(g){const c=g.shapeArgs,h=c.r,m=(c.start+c.end)/2;g=g.labelPosition;const r=g.connectorPosition,v=-h*(1-Math.cos((c.alpha||a.alpha)*k))*Math.sin(m),
    w=h*(Math.cos((c.beta||a.beta)*k)-1)*Math.cos(m);[g.natural,r.breakAt,r.touchingSliceAt].forEach(function(a){a.x+=w;a.y+=v})})}super.drawDataLabels.apply(this,arguments)}pointAttribs(a){const g=super.pointAttribs.apply(this,arguments),c=this.options;this.chart.is3d()&&!this.chart.styledMode&&(g.stroke=c.edgeColor||a.color||this.color,g["stroke-width"]=A(c.edgeWidth,1));return g}translate(){super.translate.apply(this,arguments);if(this.chart.is3d()){var a=this,g=a.options,c=g.depth||0,l=a.chart.options.chart.options3d,
    m=l.alpha,r=l.beta,v=g.stacking?(g.stack||0)*c:a._i*c;v+=c/2;!1!==g.grouping&&(v=0);a.data.forEach(function(h){var l=h.shapeArgs;h.shapeType="arc3d";l.z=v;l.depth=.75*c;l.alpha=m;l.beta=r;l.center=a.center;l=(l.end+l.start)/2;h.slicedTranslation={translateX:Math.round(Math.cos(l)*g.slicedOffset*Math.cos(m*k)),translateY:Math.round(Math.sin(l)*g.slicedOffset*Math.cos(m*k))}})}}drawTracker(){super.drawTracker.apply(this,arguments);this.chart.is3d()&&this.points.forEach(function(a){a.graphic&&["out",
    "inn","side1","side2"].forEach(g=>{a.graphic&&(a.graphic[g].element.point=a)})})}}r(G.prototype,{pointClass:w});"";return G});C(a,"Series/Pie3D/Pie3DComposition.js",[a["Series/Pie3D/Pie3DPoint.js"],a["Series/Pie3D/Pie3DSeries.js"],a["Core/Series/SeriesRegistry.js"]],function(a,w,m){m.seriesTypes.pie.prototype.pointClass.prototype.haloPath=a.prototype.haloPath;m.seriesTypes.pie=w});C(a,"Series/Scatter3D/Scatter3DPoint.js",[a["Series/Scatter/ScatterSeries.js"],a["Core/Utilities.js"]],function(a,w){const {defined:m}=
    w;class r extends a.prototype.pointClass{constructor(){super(...arguments);this.series=this.options=void 0}applyOptions(){super.applyOptions.apply(this,arguments);m(this.z)||(this.z=0);return this}}return r});C(a,"Series/Scatter3D/Scatter3DSeries.js",[a["Core/Math3D.js"],a["Series/Scatter3D/Scatter3DPoint.js"],a["Series/Scatter/ScatterSeries.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,w,m,C,k){const {pointCameraDistance:r}=a,{extend:A,merge:G}=k;class h extends m{constructor(){super(...arguments);
    this.points=this.options=this.data=void 0}pointAttribs(a){const c=super.pointAttribs.apply(this,arguments);this.chart.is3d()&&a&&(c.zIndex=r(a,this.chart));return c}}h.defaultOptions=G(m.defaultOptions,{tooltip:{pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>z: <b>{point.z}</b><br/>"}});A(h.prototype,{axisTypes:["xAxis","yAxis","zAxis"],directTouch:!0,parallelArrays:["x","y","z"],pointArrayMap:["x","y","z"],pointClass:w});C.registerSeriesType("scatter3d",h);"";return h});C(a,"masters/highcharts-3d.src.js",
    [a["Core/Globals.js"],a["Core/Renderer/SVG/SVGRenderer3D.js"],a["Core/Chart/Chart3D.js"],a["Core/Axis/ZAxis.js"],a["Core/Axis/Axis3DComposition.js"],a["Series/Area3D/Area3DSeries.js"]],function(a,w,m,C,k,J){w.compose(a.SVGRenderer);m.compose(a.Chart,a.Fx);C.compose(a.Chart);k.compose(a.Axis,a.Tick);J.compose(a.seriesTypes.area)})});
//# sourceMappingURL=highcharts-3d.js.map
