<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Vip;
use App\Models\VipUser;
use Illuminate\Http\Request;

class VipController extends Controller
{
    public function index(Request $request){
        $title = $request->title;
        $currentUrl = url()->current().'?title='.$title;
        if($title){
            $vips = Vip::where(function ($query) use($title) {
                $query->where('title', $title)
                    ->orWhere('id', $title);
            })->select(['title' , 'id'])->latest()->paginate(50)->setPath($currentUrl);
        }else{
            $vips = Vip::select(['title' , 'id'])->latest()->paginate(50)->setPath($currentUrl);
        }
        return view('admin.taxonomy.index.vip' , compact('vips','title'));
    }
    public function user(Request $request){
        $title = $request->title;
        $currentUrl = url()->current().'?title='.$title;
        if($title){
            $vips = VipUser::where(function ($query) use($title) {
                $query->where('day', $title)
                    ->orWhere('id', $title);
            })->latest()->paginate(50)->setPath($currentUrl);
        }else{
            $vips = VipUser::latest()->paginate(50)->setPath($currentUrl);
        }
        return view('admin.taxonomy.index.vipUser' , compact('vips','title'));
    }
    public function store(Request $request){
        $request->validate([
            'title' => 'required|max:255',
        ]);
        $post = Vip::create([
            'title' => $request->title,
            'day' => $request->day,
            'price' => $request->price,
            'body' => $request->body,
        ]);
        return redirect()->back()->with([
            'message' => 'اشتراک با موفقیت اضافه شد'
        ]);
    }
    public function edit(Vip $vip){
        return $vip;
    }
    public function update(Vip $vip , Request $request){
        $request->validate([
            'title' => 'required|max:220',
        ]);
        $vip->update([
            'title' => $request->title,
            'day' => $request->day,
            'price' => $request->price,
            'body' => $request->body,
        ]);
        return redirect()->back()->with([
            'message' => 'اشتراک ' . $request->title . ' با موفقیت ویرایش شد'
        ]);
    }
    public function delete(Vip $vip){
        $vip->delete();
        return redirect()->back()->with([
            'message' => 'اشتراک با موفقیت حذف شد'
        ]);
    }
}
