<?php

namespace App\Http\Controllers\Home;

use App\Http\Controllers\Controller;
use App\Http\Resources\TorobProduct;
use App\Models\Ask;
use App\Models\Category;
use App\Models\News;
use App\Models\Notice;
use App\Models\Page;
use App\Models\Product;
use App\Models\Setting;
use App\Models\Story;
use App\Models\Subscribe;
use App\Models\User;
use App\Models\Widget;
use App\Traits\SendSmsTrait;
use App\Traits\SeoHelper;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Cookie;
use Jenssegers\Agent\Agent;

class IndexController extends Controller
{
    use SeoHelper;
    use SendSmsTrait;
    public function index(Request $request){
        $this->setIndexSeo();
        $cacheTime = Setting::where('key' , 'cacheTime')->pluck('value')->first();
        $cacheStatus = Setting::where('key' , 'cacheStatus')->pluck('value')->first();
        if($cacheStatus){
            $widget = Cache::remember('widgets_cache_key2', $cacheTime, function () use($request) {
                $Agent = new Agent();
                $widgetsR = Widget::where('user_id', 0)->where('status', 1)->where('responsive', 1)->count();
                $widgets = Widget::where('user_id', 0)->where('status', 1)
                    ->when($Agent->isMobile() && $widgetsR >= 1, function ($query) {
                        return $query->where('responsive', 1);
                    }, function ($query) {
                        return $query->where('responsive', 0);
                    })
                    ->orderBy('number')
                    ->get();
                return $this->getWidget($widgets,$request);
            });
        }
        else{
            $Agent = new Agent();
            $widgetsR = Widget::where('user_id', 0)->where('status', 1)->where('responsive', 1)->count();
            $widgets = Widget::where('user_id', 0)->where('status', 1)
                ->when($Agent->isMobile() && $widgetsR >= 1, function ($query) {
                    return $query->where('responsive', 1);
                }, function ($query) {
                    return $query->where('responsive', 0);
                })
                ->orderBy('number')
                ->get();
            $widget = $this->getWidget($widgets,$request);
        }
        $vip_status = Setting::where('key' , 'vip_status')->value('value');

        $products = Product::where('status',1)->whereHas('user',function ($qs) use($vip_status){
            $qs->when($vip_status,function ($q){
                $q->has('vipActive');
            });
        })
            ->when(request()->cookie('city') != '', fn($query) => $query->where('city', request()->cookie('city')))
            ->when(request()->cookie('state') != '', fn($query) => $query->where('state', request()->cookie('state')))
            ->latest()->take(6)->get(['title','price','image','slug']);
        $stories = Story::latest()->has('user')->with('user')->take(6)->get(['title','user_id','updated_at','id','image','cover','type']);
        $categories = Category::latest()->has('product')->where('type',0)->take(6)->get();
        $bazar = $products->concat($stories)->concat($categories)->shuffle();

        $popUpStatus = Setting::where('key', 'popUpStatus')->value('value');
        $popUp = empty($_COOKIE['popUp']) && $popUpStatus == 1 ? 1 : 0;
        $imagePopUp = Setting::where('key' , 'imagePopUp')->pluck('value')->first();
        $titlePopUp = Setting::where('key' , 'titlePopUp')->pluck('value')->first();
        $addressPopUp = Setting::where('key' , 'addressPopUp')->pluck('value')->first();
        $descriptionPopUp = Setting::where('key' , 'descriptionPopUp')->pluck('value')->first();
        $buttonPopUp = Setting::where('key' , 'buttonPopUp')->pluck('value')->first();
        $moment = Product::where('status',1)->whereHas('user',function ($qs) use($vip_status){
            $qs->when($vip_status,function ($q){
                $q->has('vipActive');
            });
        })
            ->when(request()->cookie('city') != '', fn($query) => $query->where('city', request()->cookie('city')))
            ->when(request()->cookie('state') != '', fn($query) => $query->where('state', request()->cookie('state')))
            ->where('off','>=',1)->latest()->take(6)->get(['title','user_id','price','image','slug']);
        return view('home.index.index',compact('widget','bazar','popUp','popUpStatus','imagePopUp','titlePopUp','addressPopUp','descriptionPopUp','buttonPopUp','moment'));
    }
    public function filterCity(Request $request){
        Cookie::queue('state', $request->state, 100000);
        Cookie::queue('city', $request->city, 100000);
        return '';
    }
    public function getWidget($widgets , $request){
        $vip_status = Setting::where('key' , 'vip_status')->value('value');
        $widget = [];
        foreach ($widgets as $item){
            $widgetCategory = [
                'name'=> $item['name'],
                'title'=> $item['title'],
                'more'=> $item['more'],
                'description'=> $item['description'],
                'background'=> $item['background'],
                'slug'=> $item['slug'],
                'count'=> $item['count'],
                'sort'=> $item['sort'],
                'type'=> $item['type'],
                'brands'=> $item['brands'],
                'users'=> $item['users'],
                'cats'=> $item['cats'],
                'ads1'=> $item['ads1'],
                'ads2'=> $item['ads2'],
                'ads3'=> $item['ads3'],
                'post'=> [],
            ];
            if($item['name'] == 'دسته بندی' || $item['name'] == 'دسته بندی2'){
                $widgetCategory['post'] = Category::whereIn('id' , json_decode($item['cats'],true))->get();
            }
            if($item['name'] == 'معرفی سایت'){
                $users = User::whereIn('id' , json_decode($item['users'],true))->when($vip_status,function ($q){
                    $q->has('vipActive');
                })->pluck('id');
                $widgetCategory['post'] = Product::where('status',1)
                    ->when(request()->cookie('city') != '', fn($query) => $query->where('city', request()->cookie('city')))
                    ->when(request()->cookie('state') != '', fn($query) => $query->where('state', request()->cookie('state')))->latest()->whereIn('user_id', $users)->take(10)->get();
            }
            if($item['name'] == 'لحظه ای' || $item['name'] == 'محصولات اسلایدری' || $item['name'] == 'محصولات اسلایدری2' || $item['name'] == 'محصولات افقی' || $item['name'] == 'محصولات اسلایدری2' || $item['name'] == 'محصولات ویژه'){
                $widgetCategory['post'] = Product::
                    when($item['cats'] && $item['cats'] != '[]' , function ($qs) use ($item){
                        $cats = Category::whereIn('id' , json_decode($item['cats'],true))->pluck('id');
                        $qs->whereHas('category', function ($q) use ($cats) {
                            $q->whereIn('id', $cats);
                        });
                    })
                    ->when($item['users'] && $item['users'] != '[]' , function ($qs) use ($vip_status,$item){
                        $users = User::whereIn('id' , json_decode($item['users'],true))->when($vip_status,function ($q){
                            $q->has('vipActive');
                        })->pluck('id');
                        $qs->whereIn('user_id', $users);
                    })
                    ->when(request()->cookie('city') != '', fn($query) => $query->where('city', request()->cookie('city')))
                    ->when(request()->cookie('state') != '', fn($query) => $query->where('state', request()->cookie('state')))
                    ->take($item['count'])->latest()
                    ->where('status',1)->get(['id','title','price','off','image','slug','user_id']);
            }
            if($item['name'] == 'بلاگ' || $item['name'] == 'بلاگ2'){
                $cats = Category::whereIn('id' , json_decode($item['cats'],true))->pluck('id');
                if(count($cats) >= 1){
                    $widgetCategory['post'] = News::latest()->take($item['count'])->whereHas('category', function ($q) use ($cats) {
                        $q->whereIn('id', $cats);
                    })->select(['title' , 'slug' , 'imageAlt' , 'bodySeo','user_id' , 'image'])->get();
                }else{
                    $widgetCategory['post'] = News::latest()->take($item['count'])->select(['title' , 'slug' , 'imageAlt' ,'user_id' , 'bodySeo' , 'image'])->get();
                }
            }
            if($item['name'] == 'استوری' || $item['name'] == 'استوری2' || $item['name'] == 'استوری3' || $item['name'] == 'استوری4'){
                $users = User::whereIn('id' , json_decode($item['users'],true))->when($vip_status,function ($q){
                    $q->has('vipActive');
                })->pluck('id');
                $widgetCategory['post'] = Story::latest()->whereIn('user_id', $users)->get();
            }
            if($item['name'] == 'لیست غرفه'){
                $widgetCategory['post'] = User::whereIn('id' , json_decode($item['users'],true))->when($vip_status,function ($q){
                    $q->has('vipActive');
                })->get();
            }
            if($item['name'] == 'تک غرفه' || $item['name'] == 'تک غرفه2'){
                $widgetCategory['post'] = User::whereIn('id' , json_decode($item['users'],true))->when($vip_status,function ($q){
                    $q->has('vipActive');
                })->has('documentSuccess')->with("documentSuccess")->first();
            }
            array_push($widget , $widgetCategory);
        }
        return $widget;
    }
    public function faq(){
        $asks = Ask::get();
        return view('home.faq.index',compact('asks'));
    }
    public function page(Page $page){
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first() ?:'' ;
        $map = Setting::where('key' , 'map')->pluck('value')->first() ?:'' ;
        $this->seoSingleSeo(   $page->titleSeo . " - $title " , $page->bodySeo , 'store' , 'page/'."$page->slug" , $logo , $page->keyword);
        return view('home.page.index' , compact('page'));
    }

    public function search(Request $request){
        $searches = [];
        $searchEx = explode(' ',$request->search);
        foreach ($searchEx as $search){
            $products = Product::where(function ($query) use ($search){
                $query->where("title", "LIKE", "%".$search."%")
                    ->orWhere("product_id", "LIKE", "%".$search."%");
            })->where('status' , 1)->pluck('id');
            foreach ($products as $product){
                array_push($searches , $product);
            }
        }
        $arr = [];
        foreach(array_count_values($searches) as $key=>$item){
            if($item == count($searchEx)){
                array_push($arr , $key);
            }
        }
        return Product::whereIn('id' , $arr)->get(['id' ,'title','slug','image','price','product_id']);
    }


    public function sendSub(Request $request){
        $sub = Subscribe::where('name' , $request->email)->first();
        if(!$sub){
            Subscribe::create([
                'name' => $request->email
            ]);
            return 'ok';
        }else{
            return 'exist';
        }
    }
    public function getNotice(Request $request){
        if(auth()->user()){
            return Notice::where('user_id',auth()->id())->latest()->get();
        }
        return [];
    }
    public function seenNotice(Request $request){
        if(auth()->user()){
            return Notice::where('user_id',auth()->id())->update([
                'seen' => 1
            ]);
        }
    }
}
