<?php

namespace App\Http\Controllers\Home;

use App\Http\Controllers\Controller;
use App\Models\Like;
use App\Models\Notice;
use App\Models\Product;
use Illuminate\Http\Request;

class LikeController extends Controller
{
    public function store(Request $request){
        $user = auth()->user();
        if(!$user){
            return 'noUser';
        }
        $like = Like::where('product_id' , $request->product)->where('user_id' , $user->id)->first();
        if($like){
            $like->delete();
            return 'delete';
        }else{
            $like = Like::create([
                'user_id'=>$user->id,
                'product_id'=>$request->product,
            ]);
            $pr = Product::where('id',$request->product)->get(['title','user_id']);
            Notice::create([
                'user_id' => $pr->user_id,
                'seen' => 0,
                'body' => 'یک کاربر محصول ' . $pr->title . ' شما را لایک کرد.',
                'type' => 2,
            ]);
            return 'success';
        }
    }
}
