<?php

namespace App\Http\Controllers\Home;

use App\Http\Controllers\Controller;
use App\Models\Vip;
use App\Models\VipUser;
use App\Models\Wallet;
use Carbon\Carbon;
use Illuminate\Http\Request;

class VipController extends Controller
{
    public function index(){
        $vips = Vip::orderBy('price', 'asc')->get();
        $myVip = VipUser::where('user_id',auth()->id())->latest()->paginate(60);
        $myTime = VipUser::latest()->where('user_id',auth()->id())->whereDate('timeout', '>=' ,Carbon::now())->first();
        $vipE = VipUser::where('user_id',auth()->id())->whereDate('timeout', '>=' ,Carbon::now())->count();
        return view('home.profile.vip' , compact('myVip','vips','myTime','vipE'));
    }
    public function getVip(Request $request){
        $myCharge = auth()->user()->myCharge();
        $vip = Vip::where('id',$request->vip)->first();
        if($myCharge >= $vip->price){
            $vip2 = VipUser::latest()->where('user_id', auth()->id())->first();
            if ($vip2) {
                $currentExpiry = Carbon::parse($vip2->timeout);
                $newExpiry = $currentExpiry->greaterThan(Carbon::now())
                    ? $currentExpiry->addDays($vip->day)
                    : Carbon::now()->addDays($vip->day);

                VipUser::create([
                    'user_id' => auth()->id(),
                    'vip_id' => $vip->id,
                    'price' => $vip->price,
                    'day' => $vip->day,
                    'timeout' => $newExpiry,
                ]);
            } else {
                VipUser::create([
                    'user_id' => auth()->id(),
                    'vip_id' => $vip->id,
                    'price' => $vip->price,
                    'day' => $vip->day,
                    'timeout' => Carbon::now()->addDays($vip->day),
                ]);
            }
            $property = Wallet::buildCode();
            $pay = Wallet::create([
                'refId'=>'اشتراک',
                'status'=>100,
                'property'=>$property,
                'price'=>$vip->price,
                'type'=>1,
                'user_id'=>auth()->user()->id,
            ]);
            return redirect()->back()->with([
                'success' => 'اشتراک شما فعال شد'
            ]);
        }
        return abort(404);
    }
}
