<?php

namespace App\Http\Controllers\Seller;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Widget;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WidgetController extends Controller
{
    public function create(){
        $widgets = Widget::where('user_id' , auth()->id())->get();
        $cats = Category::select(['id','name'])->where('type',0)->get();
        return view('seller.widget.create',compact('cats','widgets'));
    }
    public function store(Request $request){
        Widget::where('user_id' , auth()->id())->delete();
        $i = 0;
        foreach (json_decode($request->widgets) as $item){
            Widget::create([
                'name'=> $item->name,
                'title'=> $item->title,
                'more'=> $item->more,
                'description'=> $item->description,
                'background'=> $item->background,
                'slug'=> time().$i,
                'count'=> 8,
                'user_id'=> auth()->id(),
                'sort'=> $item->sort,
                'type'=> 0,
                'status'=> $item->status,
                'brands'=> json_encode([]),
                'users'=> json_encode([]),
                'responsive'=> 0,
                'number'=> $i,
                'cats'=> $item->cats,
                'ads1'=> $item->ads1,
                'ads2'=> json_encode([]),
                'ads3'=> json_encode([]),
            ]);
            ++$i;
        }
        return 'success';
    }
    public function demo(Request $request){
        if($request->demo >= 1){
            if($request->demo == 1) {
                $demo = json_decode('[{"id":10,"name":"\u0645\u0639\u0631\u0641\u06cc \u0633\u0627\u06cc\u062a","title":"\u0628\u0627 \u0645\u0627 \u063a\u0631\u0641\u0647 \u062e\u0648\u062f\u062a\u0627\u0646 \u0631\u0627 \u062f\u0631\u0633\u062a \u06a9\u0646\u06cc\u062f!","more":"\u063a\u0631\u0641\u0647 \u062e\u0648\u062f\u062a \u0631\u0648 \u0628\u0633\u0627\u0632","number":"0","description":"\u06cc\u06a9 \u0628\u0627\u0632\u0627\u0631 \u0628\u0631\u0627\u06cc \u062e\u0631\u06cc\u062f \u0648 \u0641\u0631\u0648\u0634 \u0645\u062d\u0635\u0648\u0644\u0627\u062a \u0645\u062e\u062a\u0644\u0641 \u0628\u0627 \u06a9\u06cc\u0641\u06cc\u062a \u0648 \u0642\u06cc\u0645\u062a\u200c\u0647\u0627\u06cc \u0645\u062a\u0641\u0627\u0648\u062a\u0647. \u0628\u0627\u0633\u0644\u0627\u0645 \u0645\u062c\u0645\u0648\u0639\u0647\u200c\u0627\u06cc \u0627\u0632 \u0628\u0627\u0632\u0627\u0631\u0647\u0627\u06cc \u0628\u0632\u0631\u06af \u0647\u0645\u0647\u200c\u06cc \u0634\u0647\u0631\u0647\u0627\u0633\u062a \u0627\u0645\u0627 \u0627\u06cc\u0646\u062a\u0631\u0646\u062a\u06cc. \u0628\u0627\u0632\u0627\u0631 \u062a\u062c\u0631\u06cc\u0634 \u0648 \u0628\u0627\u0632\u0627\u0631 \u0628\u0632\u0631\u06af \u0633\u06cc\u0633\u062a\u0627\u0646 \u062f\u0631 \u0628\u0627\u0633\u0644\u0627\u0645 \u06a9\u0646\u0627\u0631 \u0647\u0645 \u0686\u06cc\u062f\u0647 \u0634\u062f\u0647. \u0627\u06cc\u0646\u200c\u062c\u0627 \u0628\u0627 \u0641\u0631\u0648\u0634\u0646\u062f\u0647\u200c\u0647\u0627 \u0648 \u062e\u0631\u06cc\u062f\u0627\u0631\u0647\u0627\u06cc \u0648\u0627\u0642\u0639\u06cc \u0633\u0631\u0648\u06a9\u0627\u0631 \u062f\u0627\u0631\u06cc\u061b \u0646\u0647 \u0627\u0646\u0628\u0627\u0631\u0647\u0627\u06cc \u062f\u0631\u0646\u062f\u0634\u062a \u0648 \u0628\u0632\u0631\u06af\u060c \u0686\u0648\u0646 \u0628\u0627\u0633\u0644\u0627\u0645 \u0628\u0627\u0632\u0627\u0631 \u0622\u062f\u0645\u200c\u0647\u0627\u0633\u062a.","background":"https:\/\/rayganapp.ir\/upload\/image\/2024\/js.webp","slug":"\/become-seller","count":"5","sort":"0","type":null,"status":"1","brands":null,"responsive":"0","users":"[\"1\",\"2\",\"3\"]","cats":"[]","ads1":"[]","ads2":null,"ads3":null,"created_at":"2024-07-14T08:32:03.000000Z","updated_at":"2024-07-23T14:28:01.000000Z"},{"id":9,"name":"\u062f\u0633\u062a\u0647 \u0628\u0646\u062f\u06cc","title":null,"more":null,"number":"1","description":null,"background":null,"slug":null,"count":null,"sort":"0","type":null,"status":"1","brands":null,"responsive":"0","users":"[]","cats":"[\"27\",\"28\",\"29\",\"30\",\"68\"]","ads1":"[]","ads2":null,"ads3":null,"created_at":"2024-07-14T08:30:10.000000Z","updated_at":"2024-07-23T14:28:01.000000Z"},{"id":18,"name":"\u062a\u0628\u0644\u06cc\u063a \u0633\u0627\u062f\u0647","title":null,"more":null,"number":"2","description":null,"background":null,"slug":null,"count":null,"sort":"0","type":null,"status":"1","brands":null,"responsive":"0","users":"[]","cats":"[]","ads1":"[{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/c11cf0a502e9cb2b6ef8e3fb32b593e2e84348b0_1629115286.jpg?x-oss-process=image\/quality,q_80\",\"address\":\"\/\"}]","ads2":null,"ads3":null,"created_at":"2024-07-23T14:27:51.000000Z","updated_at":"2024-07-23T14:28:01.000000Z"},{"id":11,"name":"\u062a\u06a9 \u063a\u0631\u0641\u0647","title":null,"more":null,"number":"3","description":null,"background":null,"slug":null,"count":null,"sort":"0","type":null,"status":"1","brands":null,"responsive":"0","users":"[\"1\",\"2\",\"3\"]","cats":"[]","ads1":"[]","ads2":null,"ads3":null,"created_at":"2024-07-14T08:32:26.000000Z","updated_at":"2024-07-23T14:28:01.000000Z"},{"id":15,"name":"\u062a\u0628\u0644\u06cc\u063a \u0633\u0627\u062f\u0647","title":null,"more":null,"number":"4","description":null,"background":null,"slug":null,"count":null,"sort":"0","type":null,"status":"1","brands":null,"responsive":"0","users":"[]","cats":"[]","ads1":"[{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/ff02be03f70ae8d8b3a21bd7758f76012db79612_1722433903.jpg?x-oss-process=image\/quality,q_95\/format,webp\",\"address\":\"\/\"},{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/7abece0d23fb2a2358105da1834393a1c65a49a1_1722753556.jpg?x-oss-process=image\/quality,q_95\/format,webp\",\"address\":\"\/\"},{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/6fc8e2d21aba219e1aa2cc93cb4a5fd66a16caac_1722416734.gif?x-oss-process=image?x-oss-process=image\/format,webp\",\"address\":\"\/\"}]","ads2":null,"ads3":null,"created_at":"2024-07-23T11:16:21.000000Z","updated_at":"2024-07-23T14:28:01.000000Z"},{"id":8,"name":"\u0627\u0633\u062a\u0648\u0631\u06cc","title":"\u0627\u0633\u062a\u0648\u0631\u06cc","more":null,"number":"5","description":null,"background":null,"slug":null,"count":null,"sort":"0","type":null,"status":"1","brands":null,"responsive":"0","users":"[\"1\",\"2\",\"3\"]","cats":"[]","ads1":"[]","ads2":null,"ads3":null,"created_at":"2024-07-14T07:59:37.000000Z","updated_at":"2024-07-23T14:28:01.000000Z"},{"id":17,"name":"\u062a\u0628\u0644\u06cc\u063a \u0633\u0627\u062f\u0647","title":null,"more":null,"number":"6","description":null,"background":null,"slug":null,"count":null,"sort":"0","type":null,"status":"1","brands":null,"responsive":"0","users":"[]","cats":"[]","ads1":"[{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/1573c10d2feef51495d49668b9d1e465c58757a8_1713603679.jpg?x-oss-process=image\/quality,q_95\/format,webp\",\"address\":\"\/\"},{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/9d3337e292fa1fa903de68cd7b5eba61de14b532_1713603787.jpg?x-oss-process=image\/quality,q_95\/format,webp\",\"address\":\"\/\"}]","ads2":null,"ads3":null,"created_at":"2024-07-23T11:22:37.000000Z","updated_at":"2024-07-23T14:28:01.000000Z"},{"id":12,"name":"\u0644\u06cc\u0633\u062a \u063a\u0631\u0641\u0647","title":"\u0641\u0631\u0648\u0634\u0646\u062f\u06af\u0627\u0646 \u0628\u0631\u062a\u0631","more":"\u0645\u0634\u0627\u0647\u062f\u0647 \u0628\u06cc\u0634\u062a\u0631","number":"7","description":null,"background":null,"slug":null,"count":null,"sort":"0","type":null,"status":"1","brands":null,"responsive":"0","users":"[\"1\",\"2\",\"3\"]","cats":"[]","ads1":"[]","ads2":null,"ads3":null,"created_at":"2024-07-14T08:33:08.000000Z","updated_at":"2024-07-23T14:28:01.000000Z"},{"id":16,"name":"\u062a\u0628\u0644\u06cc\u063a \u0633\u0627\u062f\u0647","title":null,"more":null,"number":"8","description":null,"background":null,"slug":null,"count":null,"sort":"0","type":null,"status":"1","brands":null,"responsive":"0","users":"[]","cats":"[]","ads1":"[{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/c0ac90329c1a7afd9ffba793f025dec6f03cfd3a_1658497984.jpg?x-oss-process=image\/quality,q_95\/format,webp\",\"address\":\"\/\"},{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/870bc573996f86e8770f43ff922ecc7da7d97b73_1658498259.jpg?x-oss-process=image\/quality,q_95\/format,webp\",\"address\":\"\/\"},{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/23248bc94a1cc98e98f16d742a825ef0284717fe_1658498127.jpg?x-oss-process=image\/quality,q_95\/format,webp\",\"address\":\"\/\"},{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/96d1537e1a684ba918b6111ffdd3dfc9e13bd7f4_1658498413.jpg?x-oss-process=image\/quality,q_95\/format,webp\",\"address\":\"\/\"}]","ads2":null,"ads3":null,"created_at":"2024-07-23T11:20:26.000000Z","updated_at":"2024-07-23T14:28:01.000000Z"},{"id":13,"name":"\u0628\u0627\u0632\u0627\u0631\u06af\u0631\u062f\u06cc","title":"\u0628\u0627\u0632\u0627\u0631\u06af\u0631\u062f\u06cc","more":"\u062c\u0647\u062a \u0645\u0634\u0627\u0647\u062f\u0647 \u0628\u06cc\u0634\u062a\u0631 \u06a9\u0644\u06cc\u06a9 \u06a9\u0646","number":"9","description":null,"background":null,"slug":"\/","count":null,"sort":"0","type":null,"status":"1","brands":null,"responsive":"0","users":"[]","cats":"[]","ads1":"[]","ads2":null,"ads3":null,"created_at":"2024-07-14T08:33:49.000000Z","updated_at":"2024-07-23T14:28:01.000000Z"},{"id":14,"name":"\u0628\u0644\u0627\u06af","title":"\u0628\u0644\u0627\u06af \u0647\u0627 \u0645\u0627","more":"\u0645\u0634\u0627\u0647\u062f\u0647 \u0647\u0645\u0647 \u0628\u0644\u0627\u06af \u0647\u0627","number":"10","description":null,"background":null,"slug":null,"count":null,"sort":"0","type":null,"status":"1","brands":null,"responsive":"0","users":"[]","cats":"[]","ads1":"[]","ads2":null,"ads3":null,"created_at":"2024-07-14T08:34:47.000000Z","updated_at":"2024-07-23T14:28:01.000000Z"}]');
            }elseif($request->demo == 2) {
                $demo = json_decode('[{"id":93,"name":"\u062a\u0628\u0644\u06cc\u063a \u0628\u0632\u0631\u06af","title":null,"more":null,"number":0,"description":null,"background":null,"slug":null,"user_id":1,"count":null,"sort":null,"type":null,"status":1,"brands":null,"responsive":0,"users":"[1]","cats":null,"ads1":"[{\"image\":\"https:\/\/statics.basalam.com\/public-27\/photo\/explore\/aN\/07-31\/CWI7Dw5u3T8cJwZRT5ORMxmngABBvXWCV4q96IDxpDu30C6ktX.jpg\",\"address\":\"\/\"},{\"image\":\"https:\/\/statics.basalam.com\/public-27\/photo\/explore\/aN\/07-31\/CWI7Dw5u3T8cJwZRT5ORMxmngABBvXWCV4q96IDxpDu30C6ktX.jpg\",\"address\":\"\/\"}]","ads2":null,"ads3":null,"created_at":"2025-01-03T12:43:10.000000Z","updated_at":"2025-01-03T12:43:10.000000Z"},{"id":94,"name":"\u062f\u0633\u062a\u0647 \u0628\u0646\u062f\u06cc2","title":null,"more":null,"number":0,"description":null,"background":null,"slug":null,"user_id":1,"count":null,"sort":null,"type":null,"status":1,"brands":null,"responsive":0,"users":"[1]","cats":"[\"27\",\"28\",\"29\",\"30\",\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\",\"38\"]","ads1":"","ads2":null,"ads3":null,"created_at":"2025-01-03T12:43:10.000000Z","updated_at":"2025-01-03T12:43:10.000000Z"},{"id":95,"name":"\u062a\u0628\u0644\u06cc\u063a \u0633\u0627\u062f\u0647","title":null,"more":null,"number":0,"description":null,"background":null,"slug":null,"user_id":1,"count":null,"sort":null,"type":null,"status":1,"brands":null,"responsive":0,"users":"[1]","cats":null,"ads1":"[{\"image\":\"https:\/\/statics.basalam.com\/public-27\/photo\/explore\/aN\/07-31\/sDcVFgZrioJd9poOGhPi1I6zNvChySL2n8vGvInpctijXejFpn.jpg\",\"address\":\"\/\"}]","ads2":null,"ads3":null,"created_at":"2025-01-03T12:43:10.000000Z","updated_at":"2025-01-03T12:43:10.000000Z"},{"id":96,"name":"\u0627\u0633\u062a\u0648\u0631\u06cc2","title":"\u062f\u0627\u0633\u062a\u0627\u0646 \u0645\u0627","more":null,"number":0,"description":null,"background":null,"slug":null,"user_id":1,"count":null,"sort":null,"type":null,"status":1,"brands":null,"responsive":0,"users":"[1]","cats":"","ads1":"","ads2":null,"ads3":null,"created_at":"2025-01-03T12:43:10.000000Z","updated_at":"2025-01-03T12:43:10.000000Z"},{"id":97,"name":"\u062a\u0628\u0644\u06cc\u063a \u0633\u0627\u062f\u0647","title":null,"more":null,"number":0,"description":null,"background":null,"slug":null,"user_id":1,"count":null,"sort":null,"type":null,"status":1,"brands":null,"responsive":0,"users":"[1]","cats":null,"ads1":"[{\"image\":\"https:\/\/statics.basalam.com\/public-28\/photo\/explore\/aN\/08-03\/qcdi4tTuBkqTdR3PxIGFDITov8wHD6f5ZaS8LRpnOoucsqfkRu.jpg\",\"address\":\"\/\"}]","ads2":null,"ads3":null,"created_at":"2025-01-03T12:43:10.000000Z","updated_at":"2025-01-03T12:43:10.000000Z"},{"id":98,"name":"\u0627\u0633\u062a\u0648\u0631\u06cc2","title":"\u0627\u0647\u0627\u0644\u06cc \u0631\u0648 \u0628\u0647 \u0686\u06cc \u0645\u06cc\u200c\u0634\u0646\u0627\u0633\u0646\u061f","more":null,"number":0,"description":null,"background":null,"slug":null,"user_id":1,"count":null,"sort":null,"type":null,"status":1,"brands":null,"responsive":0,"users":"[1]","cats":"","ads1":"","ads2":null,"ads3":null,"created_at":"2025-01-03T12:43:10.000000Z","updated_at":"2025-01-03T12:43:10.000000Z"},{"id":99,"name":"\u062a\u06a9 \u063a\u0631\u0641\u0647","title":"\u0628\u0627\u0632\u0627\u0631\u06af\u0631\u062f\u06cc","more":"\u0628\u06cc\u0634\u062a\u0631","number":0,"description":null,"background":null,"slug":null,"user_id":1,"count":null,"sort":null,"type":null,"status":1,"brands":null,"responsive":0,"users":"[1]","cats":"","ads1":"","ads2":null,"ads3":null,"created_at":"2025-01-03T12:43:10.000000Z","updated_at":"2025-01-03T12:43:10.000000Z"},{"id":100,"name":"\u062a\u0628\u0644\u06cc\u063a \u0633\u0627\u062f\u0647","title":null,"more":null,"number":0,"description":null,"background":null,"slug":null,"user_id":1,"count":null,"sort":null,"type":null,"status":1,"brands":null,"responsive":0,"users":"[1]","cats":null,"ads1":"[{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/ff02be03f70ae8d8b3a21bd7758f76012db79612_1722433903.jpg?x-oss-process=image\/quality,q_95\/format,webp\",\"address\":\"\/\"},{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/7abece0d23fb2a2358105da1834393a1c65a49a1_1722753556.jpg?x-oss-process=image\/quality,q_95\/format,webp\",\"address\":\"\/\"},{\"image\":\"https:\/\/dkstatics-public.digikala.com\/digikala-adservice-banners\/6fc8e2d21aba219e1aa2cc93cb4a5fd66a16caac_1722416734.gif?x-oss-process=image?x-oss-process=image\/format,webp\",\"address\":\"\/\"}]","ads2":null,"ads3":null,"created_at":"2025-01-03T12:43:10.000000Z","updated_at":"2025-01-03T12:43:10.000000Z"},{"id":101,"name":"\u0644\u062d\u0638\u0647 \u0627\u06cc","title":"\u0645\u062d\u0635\u0648\u0644\u0627\u062a \u0645\u0627","more":"\u0628\u06cc\u0634\u062a\u0631","number":0,"description":null,"background":null,"slug":null,"user_id":1,"count":null,"sort":null,"type":null,"status":1,"brands":null,"responsive":0,"users":"[1]","cats":"","ads1":"","ads2":null,"ads3":null,"created_at":"2025-01-03T12:43:10.000000Z","updated_at":"2025-01-03T12:43:10.000000Z"},{"id":102,"name":"\u0628\u0644\u0627\u06af2","title":"\u0628\u0644\u0627\u06af \u0647\u0627","more":"\u0645\u0634\u0627\u0647\u062f\u0647 \u0628\u06cc\u0634\u062a\u0631","number":0,"description":null,"background":null,"slug":null,"user_id":1,"count":null,"sort":null,"type":null,"status":1,"brands":null,"responsive":0,"users":"[1]","cats":"[]","ads1":"[{\"image\":\"https:\/\/statics.basalam.com\/public-27\/photo\/explore\/aN\/07-31\/sDcVFgZrioJd9poOGhPi1I6zNvChySL2n8vGvInpctijXejFpn.jpg\",\"address\":\"\/\"}]","ads2":null,"ads3":null,"created_at":"2025-01-03T12:43:10.000000Z","updated_at":"2025-01-03T12:43:10.000000Z"},{"id":103,"name":"\u0645\u062d\u0635\u0648\u0644\u0627\u062a \u0627\u0633\u0644\u0627\u06cc\u062f\u0631\u06cc","title":"\u0645\u062d\u0635\u0648\u0644\u0627\u062a \u062c\u062f\u06cc\u062f","more":"\u0628\u06cc\u0634\u062a\u0631","number":0,"description":null,"background":null,"slug":null,"user_id":1,"count":null,"sort":null,"type":null,"status":1,"brands":null,"responsive":0,"users":"[1]","cats":"","ads1":"","ads2":null,"ads3":null,"created_at":"2025-01-03T12:43:10.000000Z","updated_at":"2025-01-03T12:43:10.000000Z"}]');
            }
            DB::table('widgets')->where('user_id',auth()->id())->delete();
            foreach ($demo as $item){
                Widget::create([
                    'name'=> $item->name,
                    'title'=> $item->title,
                    'more'=> $item->more,
                    'description'=> $item->description,
                    'background'=> $item->background,
                    'slug'=> $item->slug,
                    'count'=> $item->count,
                    'sort'=> $item->sort,
                    'type'=> $item->type,
                    'status'=> $item->status,
                    'brands'=> $item->brands,
                    'users'=> json_encode([auth()->id()]),
                    'responsive'=> $item->responsive,
                    'cats'=> $item->cats,
                    'ads1'=> $item->ads1,
                    'ads2'=> $item->ads2,
                    'ads3'=> $item->ads3,
                    'user_id'=> auth()->id(),
                ]);
            }
        }
        return redirect()->back()->with([
            'message' => 'دمو ساخته شد'
        ]);
    }
}
