<?php

namespace App\Http\Middleware;

use App\Models\Setting;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckSeller
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if(auth()->user()){
            if(auth()->user()->seller != 0){
                if(!auth()->user()->documentSuccess){
                    auth()->user()->update([
                        'seller' => 0
                    ]);
                }else{
                    $vip_status = Setting::where('key' , 'vip_status')->value('value');
                    if($vip_status){
                        if(auth()->user()->vipActive == ''){
                            return redirect('/profile/vip');
                        }
                    }
                    return $next($request);
                }
            }
        }
        return redirect('/login');
    }
}
