<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notice extends Model
{
    use HasFactory;
    protected $fillable=[
        'user_id',
        'seen',
        'body',
        'type',
    ];
    public function user()
    {
        return $this->belongsTo(User::class,'user_id','id');
    }
    public function getCreatedAtAttribute($value)
    {
        return verta($value)->formatDifference();
    }
}
