@extends('admin.master')

@section('tab',13)
@section('content')
    <div class="allCreatePost">
        <div class="allCreatePost">
            <div class="allPostPanelTop">
                <h1>ایجاد بلاگ با هوش مصنوعی</h1>
                <div class="allPostTitle">
                    <a href="/admin">داشبورد</a>
                    <span>/</span>
                    <a href="/admin/ai/image">ایجاد بلاگ با هوش مصنوعی</a>
                </div>
            </div>
            <div class="allCreatePostData">
                <div class="allCreatePostSubject">
                    <div class="allCreatePostItem">
                        <label>توضیحات دلخواه :</label>
                        <textarea name="body"></textarea>
                    </div>
                    <div class="allCreatePostItem type0" style="display: none">
                        <label>توضیحات :</label>
                        <textarea name="body2" class="editor"></textarea>
                    </div>
                    <div class="buttons">
                        <button class="button createBlog type0" style="display: none" type="submit">ایجاد بلاگ</button>
                        <button class="button" name="createPost" type="submit">تولید متن</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts3')
    <script>
        $(document).ready(function(){
            $("button[name='createPost']").click(function(event){
                $("button[name='createPost']").text('صبر کنید ...');
                var body = $("textarea[name='body']").val();

                var form = {
                    "_token": "{{ csrf_token() }}",
                    body: body,
                };
                $.ajax({
                    url: "/admin/ai/blog",
                    type: "post",
                    data: form,
                    success: function (data) {
                        $(".type0").show();
                        $(".editor").val(data);
                        $("button[name='createPost']").text('تولید متن');
                    },
                    error: function (xhr) {
                        alert('موجودی حساب شما به اتمام رسید و نیاز به شارژ حساب دارید.')
                        $("button[name='createPost']").text('تولید متن');
                    }
                });
            });
            $(".createBlog").click(function(event){
                $(".createBlog").text('صبر کنید ...');
                var body = $("textarea[name='body']").val();
                var body2 = $("textarea[name='body2']").val();

                var form = {
                    "_token": "{{ csrf_token() }}",
                    body: body,
                    body2: body2,
                };
                $.ajax({
                    url: "/admin/ai/blog/create",
                    type: "post",
                    data: form,
                    success: function (data) {
                        window.location.href = '/admin/blog/'+data.id+'/edit';
                    },
                });
            });
        })
    </script>
@endsection
