@extends('admin.master')

@section('title' , 'همکاری در فروش')
@section('tab' , 6)
@section('content')
    <div class="allHall">
        @if (\Session::has('message'))
            <div class="success">
                {!! \Session::get('message') !!}
            </div>
        @endif
        <div class="allTables">
            <div class="allData">
                <table class="grid5">
                    <tr>
                        <th>مبلغ</th>
                        <th>سفارش</th>
                        <th>وضعیت</th>
                        <th>کاربر</th>
                        <th>زمان ثبت</th>
                    </tr>
                    @foreach($affiliates as $item)
                        <tr>
                            <td>
                                <span>{{number_format($item->price)}} تومان </span>
                            </td>
                            <td>
                                <a href="/admin/pay/{{\App\Models\PayMeta::where('id',$item->pay_id)->value('pay_id')}}">{{\App\Models\PayMeta::where('id',$item->pay_id)->first()->pay()->value('property')}}</a>
                            </td>
                            <td>
                                @if($item->status == 1)
                                    امکان تسویه
                                @else
                                    بلوکه شده
                                @endif
                            </td>
                            <td>
                                <a href="/admin/user/{{$item->user?$item->user->id:0}}/edit">{{$item->user?$item->user->name:'-'}}</a>
                            </td>
                            <td>
                                <span>{{$item->created_at}}</span>
                            </td>
                        </tr>
                    @endforeach
                </table>
                {{ $affiliates->links('admin.paginate') }}
            </div>
        </div>
    </div>
@endsection

@section('scripts3')
    <script>
        $(document).ready(function(){
            var post = 0;
            $('.popUp').hide();
            $('.filterContent').hide();
            $('.filterTitle').click(function(){
                $('.filterContent').toggle();
            })
            $('#cancelDelete').click(function(){
                $('.popUp').hide();
                post = 0;
            })
            $('#deletePost').click(function(){
                $('.popUp').hide();
            });
            $('.buttons').on('click' , '.deleteButton' ,function(){
                post = this.id;
                $('.popUp').show();
                $('.buttonsPop form').attr('action' , '/admin/affiliate/' + post+'/delete');
            })
        })
    </script>
@endsection
