@extends('admin.master')

@section('title' , 'اشتراک ها')
@section('tab' , 37)
@section('content')
    <div class="allHall">
        @if (\Session::has('message'))
            <div class="success">
                {!! \Session::get('message') !!}
            </div>
        @endif
        <div class="allTables">
            <div class="allData">
                <table class="grid5">
                    <tr>
                        <th>اشتراک</th>
                        <th>مبلغ</th>
                        <th>تعداد روز</th>
                        <th>کاربر</th>
                        <th>زمان اتمام</th>
                        <th>زمان ثبت</th>
                    </tr>
                    @foreach($vips as $item)
                        <tr>
                            <td>
                                <span>{{$item->vip?$item->vip->title:'-'}}</span>
                            </td>
                            <td>
                                <span>{{number_format($item->price)}} تومان </span>
                            </td>
                            <td>
                                <span>{{$item->day}}</span>
                            </td>
                            <td>
                                <a href="/admin/customer/{{$item->user?$item->user->id:0}}/show">{{$item->user?$item->user->name:'-'}}</a>
                            </td>
                            <td>
                                <span>{{verta($item->timeout)->format(' H:i | %d / %B / %Y')}}</span>
                            </td>
                            <td>
                                <span>{{$item->created_at}}</span>
                            </td>
                        </tr>
                    @endforeach
                </table>
                {{ $vips->links('admin.paginate') }}
            </div>
        </div>
    </div>
@endsection

@section('scripts3')
    <script>
        $(document).ready(function(){
            var post = 0;
            $('.popUp').hide();
            $('.filterContent').hide();
            $('.filterTitle').click(function(){
                $('.filterContent').toggle();
            })
            $('#cancelDelete').click(function(){
                $('.popUp').hide();
                post = 0;
            })
            $('#deletePost').click(function(){
                $('.popUp').hide();
            });
            $('.buttons').on('click' , '.deleteButton' ,function(){
                post = this.id;
                $('.popUp').show();
                $('.buttonsPop form').attr('action' , '/admin/views/' + post+'/delete');
            })
        })
    </script>
@endsection
