@if(\App\Models\Setting::where('key' , 'aiApiKey')->pluck('value')->first())
    <div class="allChatIndex">
        <div class="allChatIndexBlock">
            <div class="chatContents">
                <div class="chatContent" id="chatContent4">
                    <div class="header">
                        <div class="title2">سوالات خود را از هوش مصنوعی بپرسید</div>
                        <div class="leftHeader">
                            <i class="cancelChat">
                                <svg class="icon">
                                    <use xlink:href="#cancel"></use>
                                </svg>
                            </i>
                        </div>
                    </div>
                    <div class="body online1">
                        <div class="messages opp">
                            <div class="text">🤖 سوالاتتان را در مورد سفارش و... بفرمایید</div>
                        </div>
                    </div>
                    <div class="send">
                        <input type="text" name="body" placeholder="پیغام خود را بنویسید">
                        <button>ارسال</button>
                    </div>
                </div>
            </div>
            <div class="chatButtons">
                <div class="text">ارتباط با هوش مصنوعی</div>
                <div class="chatButton">
                    <i>
                        <svg class="icon">
                            <use xlink:href="#user-robot"></use>
                        </svg>
                    </i>
                </div>
            </div>
        </div>
    </div>
@endif

<script>
    $(document).ready(function(){
        $(".allChatIndex .chatButtons,.allChatIndex .cancelChat").click(function (){
            $('.allChatIndex .chatContents').toggle();
        })
        $(".allChatIndex #chatContent4 .send button").click(function (){
            $(".allChatIndex #chatContent4 .send button").text('صبر کنید');
            $('.allChatIndex #chatContent4 .body').animate({ scrollTop: $('.allChatIndex #chatContent4 .body').height() + 20000 }, 1000);
            var ss = $(".allChatIndex #chatContent4 .send input[name='body']").val();
            $(".allChatIndex #chatContent4 .send button").text('ارسال');
            $('.allChatIndex #chatContent4 .body').append(
                $(`<div class="messages me new">
                            <div class="text">${ss}</div>
                        </div>`)
            );
            $(".allChatIndex #chatContent4 .send input[name='body']").val('');
            let formData = new FormData();
            formData.append('_token', "{{ csrf_token() }}");
            formData.append('body', ss);
            $.ajax({
                url: "/send-ai-ticket",
                type: "post",
                data: formData,
                contentType: false,
                processData: false,
                success: function (data) {
                    $('.allChatIndex #chatContent4 .body').append(
                        $(`<div class="messages new">
                            <div class="text">🤖 ${data}</div>
                        </div>`)
                    );
                },
                error: function (xhr) {
                    $.toast({
                        heading: 'مشکلی پیش امده', // Optional heading to be shown on the toast
                        icon: 'error', // Type of toast icon
                        showHideTransition: 'fade', // fade, slide or plain
                        allowToastClose: true, // Boolean value true or false
                        hideAfter: 3000, // false to make it sticky or number representing the miliseconds as time after which toast needs to be hidden
                        stack: 5, // false if there should be only one toast at a time or a number representing the maximum number of toasts to be shown at a time
                        position: 'bottom-left', // bottom-left or bottom-right or bottom-center or top-left or top-right or top-center or mid-center or an object representing the left, right, top, bottom values
                        textAlign: 'left',
                        loader: true,
                        loaderBg: '#c60000',
                    });
                    $(".allChatIndex #chatContent4 .send button").text('ارسال');
                }
            });
        })
    })
</script>
