@if($data['post'])
    <div class="allSellerDetail2 width">
        <div class="right">
            <div class="top">
                <div class="pic">
                    <img src="{{$data['post']['profile']??'/img/user.png'}}" alt="{{$data['post']['name']}}">
                </div>
                <div class="names">
                    <div class="name">{{$data['post']['name']}}</div>
                    <div class="count">{{count($data['post']['product'])}} محصول</div>
                </div>
            </div>
            <p>{{$data['post']['body']}}</p>
            <div class="options">
                <div class="option">
                    <i>
                        <svg class="icon">
                            <use xlink:href="#star"></use>
                        </svg>
                    </i>
                    <div class="title2">امتیاز</div>
                    <div class="count">{{\App\Models\Comment::where('type',1)->where('product_id',$data['post']['id'])->where('status',1)->avg('rate')??'5'}} / 5</div>
                </div>
                <div class="option">
                    <i>
                        <svg class="icon">
                            <use xlink:href="#clock"></use>
                        </svg>
                    </i>
                    <div class="title2">میزان فعالیت</div>
                    <div class="count">{{$data['post']['documentSuccess'] ? str_replace('قبل','',$data['post']['documentSuccess']['created_at']) : '-'}}</div>
                </div>
                <a href="/{{'@'.$data['post']['slug']}}" class="option">
                    <i>
                        <svg class="icon">
                            <use xlink:href="#more"></use>
                        </svg>
                    </i>
                    <div class="title2">مشاهده</div>
                    <div class="count">همه محصولات</div>
                </a>
            </div>
        </div>
        <div class="left">
            <div class="swiper detailSwiper2" dir="rtl">
                <div class="swiper-wrapper">
                    @foreach(\App\Models\Product::where('user_id',$data['post']['id'])->where('status',1)->take(5)->get() as $item)
                        <div class="swiper-slide">
                            <a href="/product/{{$item->slug}}">
                                <div class="pic">
                                    <img lazy="loading" class="lazyload" src="/img/404Image.png" data-src="{{$item->image != '[]' ? json_decode($item->image)[0] : ''}}" alt="{{$item->title}}">
                                    @if($item->off >= 1)
                                        <div class="tag">
                                            <span>%{{$item->off}}</span>
                                        </div>
                                    @endif
                                </div>
                                <div class="title3">{{$item->title}}</div>
                                <div class="price">{{number_format($item->price)}}</div>
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="iconL">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 77.888 265.971">
                    <g id="Group_4" data-name="Group 4" transform="translate(-4500 -3729.451)">
                        <path id="Path_1" data-name="Path 1" d="M4314.485,3993.422c-.392-15.07,12.917-36.011,12.917-36.011s32.032-35.188,35.521-38.7c2.75-2.765,6.522-5.618,17.223-20.6,26.421-36.989,0-74.37,0-74.37s-34.249-37.772-49.319-54.016S4314,3727.451,4314,3727.451Z" transform="translate(186 2)" fill="none"/>
                        <line id="Line_5" data-name="Line 5" x1="11" y2="11" transform="translate(4523.5 3858.5)" fill="none" stroke="#707070" stroke-width="5"/>
                        <line id="Line_6" data-name="Line 6" x1="11" y1="11" transform="translate(4523.5 3866.5)" fill="none" stroke="#707070" stroke-width="5"/>
                    </g>
                </svg>
            </div>
            <div class="iconR">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 77.888 265.971">
                    <g id="Group_4" data-name="Group 4" transform="translate(-4500 -3729.451)">
                        <path id="Path_1" data-name="Path 1" d="M4314.485,3993.422c-.392-15.07,12.917-36.011,12.917-36.011s32.032-35.188,35.521-38.7c2.75-2.765,6.522-5.618,17.223-20.6,26.421-36.989,0-74.37,0-74.37s-34.249-37.772-49.319-54.016S4314,3727.451,4314,3727.451Z" transform="translate(186 2)" fill="none"/>
                        <line id="Line_5" data-name="Line 5" x1="11" y2="11" transform="translate(4523.5 3858.5)" fill="none" stroke="white" stroke-width="5"/>
                        <line id="Line_6" data-name="Line 6" x1="11" y1="11" transform="translate(4523.5 3866.5)" fill="none" stroke="white" stroke-width="5"/>
                    </g>
                </svg>
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>
    </div>
@endif
