@extends('home.master')

@section('title' , 'اشتراک')
@section('content')
    <div class="allProfileIndex width">
        @include('home.profile.list' , ['tab'=>8])
        <div class="allVipIndex">
            @if (\Session::has('success'))
                <div class="success">
                    {!! \Session::get('success') !!}
                </div>
            @endif
            @if (\Session::has('error'))
                <div class="error">
                    {!! \Session::get('error') !!}
                </div>
            @endif
            <div class="chargeWidgets">
                <div class="WidgetItem">
                    <div class="WidgetIcon">
                        <svg class="icon">
                            <use xlink:href="#successPay"></use>
                        </svg>
                    </div>
                    <div class="WidgetSubject">
                        <h4>تعداد اشتراک ها</h4>
                        <h5>{{number_format($myVip->total())}} اشتراک </h5>
                    </div>
                </div>
                <div class="WidgetItem">
                    <div class="WidgetIcon">
                        <svg class="icon">
                            <use xlink:href="#successPay"></use>
                        </svg>
                    </div>
                    <div class="WidgetSubject">
                        <h4>زمان اتمام اشتراک</h4>
                        <h5>{{$myTime?verta($myTime->timeout)->format(' H:i | %d / %B / %Y'):'-'}}</h5>
                    </div>
                </div>
                <div class="WidgetItem">
                    <div class="WidgetIcon">
                        <svg class="icon">
                            <use xlink:href="#successPay"></use>
                        </svg>
                    </div>
                    <div class="WidgetSubject">
                        <h4>تعداد روز باقیمانده</h4>
                        <h5>
                            @if($myTime)
                                {{number_format(\Carbon\Carbon::parse($myTime->timeout)->diffInDays()) . ' روز'}}
                                @if(\Carbon\Carbon::parse($myTime->timeout)->diffInHours() % 24 != 0)
                                    {{\Carbon\Carbon::parse($myTime->timeout)->diffInHours() % 24 . ' ساعت'}}
                                @endif
                            @else
                                -
                            @endif
                         </h5>
                    </div>
                </div>
                <div class="WidgetItem">
                    <div class="WidgetIcon">
                        <svg class="icon">
                            <use xlink:href="#successPay"></use>
                        </svg>
                    </div>
                    <div class="WidgetSubject">
                        <h4>اشتراک های فعال</h4>
                        <h5>{{number_format($vipE)}} اشتراک </h5>
                    </div>
                </div>
            </div>
            <div class="packs">
                <div class="title">اشتراک هایی که موجود است</div>
                <p class="body">با خرید اشتراک به پنل فروشندگی دسترسی خواهید داشت.</p>
                <div class="items">
                    @foreach($vips as $item)
                        <form action="/profile/get-vip" method="post" class="item">
                            @csrf
                            <input name="vip" type="hidden" value="{{$item->id}}">
                            <h4>{{$item->title}}</h4>
                            <p>{{$item->body}}</p>
                            <div class="option">
                                <span>تعداد روز اشتراک :</span>
                                <span>{{number_format($item->day)}}</span>
                            </div>
                            <div class="option">
                                <span>مبلغ قابل پرداخت :</span>
                                <span>{{number_format($item->price)}} تومان</span>
                            </div>
                            <div class="option">
                                <span>زمان اتمام اشتراک :</span>
                                <span>{{verta(\Carbon\Carbon::now()->addDays($item->day))->format(' H:i | %d / %m / %Y')}}</span>
                            </div>
                            @if($item->price <= auth()->user()->myCharge())
                                <button class="button">خرید اشتراک</button>
                            @else
                                <a href="/charge" class="button">شارژ کیف پول</a>
                            @endif
                        </form>
                    @endforeach
                </div>
            </div>
            <div class="allTables">
                <table>
                    <tr>
                        <th>اشتراک</th>
                        <th>مبلغ</th>
                        <th>تعداد روز</th>
                        <th>زمان اتمام</th>
                        <th>زمان ثبت</th>
                    </tr>
                    @foreach($myVip as $item)
                        <tr>
                            <td>
                                <span>{{$item->vip?$item->vip->title:'-'}}</span>
                            </td>
                            <td>
                                <span>{{number_format($item->price)}} تومان </span>
                            </td>
                            <td>
                                <span>{{$item->day}}</span>
                            </td>
                            <td>
                                <span>{{verta($item->timeout)->format(' H:i | %d / %B / %Y')}}</span>
                            </td>
                            <td>
                                <span>{{$item->created_at}}</span>
                            </td>
                        </tr>
                    @endforeach
                </table>
            </div>
        </div>
    </div>
@endsection
